/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel.context.statement;

import com.huawei.gauss.channel.context.statement.Interval;
import java.sql.SQLException;

public class IntervalDS
extends Interval {
    private static final long ITVL_UNITS_PER_DAY = 86400000000L;
    private static final long ITVL_UNITS_PER_HOUR = 3600000000L;
    private static final long ITVL_UNITS_PER_MINUTE = 60000000L;
    private static final long ITVL_UNITS_PER_SECOND = 1000000L;
    private static final long ITVL_UNITS_PER_MILLIS = 1000L;
    private static final long ITVL_NANOS_PER_MICROSEC = 1000L;
    private static final long serialVersionUID = 0L;

    IntervalDS() {
        super(0L);
    }

    public IntervalDS(long itvl) {
        super(itvl);
    }

    @Override
    public String stringValue() {
        return this.toString();
    }

    public String toString() {
        return IntervalDS.toString(this.longValue());
    }

    public static String toString(long itvl) {
        long innerItvl = itvl;
        StringBuilder sb = new StringBuilder();
        if (innerItvl < 0L) {
            sb.append('-');
            innerItvl = -innerItvl;
        }
        int days = (int)(innerItvl / 86400000000L);
        sb.append(days);
        sb.append(' ');
        int hours = (int)((innerItvl -= (long)days * 86400000000L) / 3600000000L);
        sb.append(hours);
        sb.append(':');
        int minutes = (int)((innerItvl -= (long)hours * 3600000000L) / 60000000L);
        sb.append(minutes);
        sb.append(':');
        int seconds = (int)((innerItvl -= (long)minutes * 60000000L) / 1000000L);
        sb.append(seconds);
        sb.append('.');
        sb.append((innerItvl -= (long)seconds * 1000000L) * 1000L);
        return sb.toString();
    }

    public int getNanos() {
        return (int)(this.longValue() % 1000000L * 1000L);
    }

    public long getMillis() {
        return this.longValue() / 1000L;
    }

    @Override
    public boolean isConvertibleTo(Class class1) {
        return class1.getName().compareTo("java.lang.String") == 0 || class1.getName().compareTo("java.lang.Long") == 0;
    }

    @Override
    public Object makeJdbcArray(int i) {
        return new IntervalDS[i];
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }
}

