/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel.context.statement;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.ParamAlignHelper;
import com.huawei.gauss.channel.context.statement.ParamsDataProcessor;
import com.huawei.gauss.exception.ExceptionUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ParamsData {
    ParamInfo[] paramInfos;
    final List<ParamData> paramsCache;
    int position;
    int mark;
    final int paramCount;
    final boolean isBigEndianess;
    ParamsDataProcessor processor;
    ParamData currentParam;
    int callVersion;
    boolean needSetInOutType = false;

    public ParamsData(int paramCount, boolean isBigEndianess, int connVersion) {
        this.paramCount = paramCount;
        this.paramInfos = new ParamInfo[paramCount];
        this.currentParam = new ParamData(paramCount);
        this.paramsCache = new ArrayList<ParamData>();
        this.isBigEndianess = isBigEndianess;
        this.callVersion = connVersion;
    }

    public void setParamValue(int index, FieldType dataType, Object value) throws SQLException {
        if (index < 1 || index > this.paramCount) {
            throw ExceptionUtil.illegalJDBCArgumentExceptionWithErrCode("Column index starts from 1 to" + this.paramCount + ", but index is [" + index + "].", 504);
        }
        int realIndex = index - 1;
        this.currentParam.setParamValue(realIndex, dataType, value);
        if (this.needSetInOutType) {
            this.currentParam.setInOutType(realIndex, 64);
        }
    }

    public void setParamCalendar(int index, Calendar cal) throws SQLException {
        if (index < 1 || index > this.paramCount) {
            throw ExceptionUtil.illegalJDBCArgumentExceptionWithErrCode("Column index starts from 1 to" + this.paramCount + ", but index is [" + index + "].", 504);
        }
        int realIndex = index - 1;
        this.currentParam.setParamCalendar(realIndex, cal);
    }

    public void setParamType(int index, int jdbcType) throws SQLException {
        if (index < 1 || index > this.paramCount) {
            throw ExceptionUtil.illegalJDBCArgumentExceptionWithErrCode("Column index starts from 1 to " + this.paramCount + ", but index is [" + index + "].", 504);
        }
        int realIndex = index - 1;
        FieldType fieldType = FieldType.getGaussTypeFromJDBCType(jdbcType);
        this.currentParam.setOutParamType(realIndex, fieldType);
    }

    public void addBatch() throws SQLException {
        if (this.paramCount < 1) {
            return;
        }
        this.currentParam.checkHasNoBindColumn();
        for (int i = 0; i < this.paramCount; ++i) {
            FieldType dataType = this.currentParam.params[i].dataType;
            this.alignParamType(i, dataType);
        }
        this.paramsCache.add(this.currentParam);
        this.currentParam = new ParamData(this.paramCount);
    }

    private void alignParamType(int realIndex, FieldType dataType) throws SQLException {
        ParamInfo info = this.paramInfos[realIndex];
        if (info == null) {
            info = new ParamInfo();
            info.alignType = dataType;
            this.paramInfos[realIndex] = info;
            return;
        }
        if (dataType.equals((Object)info.alignType)) {
            return;
        }
        ParamAlignHelper.alignType(info, dataType);
    }

    public void clear() {
        this.paramsCache.clear();
        this.currentParam.clear();
        this.position = 0;
        this.mark = 0;
        this.processor = null;
        for (int i = 0; i < this.paramCount; ++i) {
            this.paramInfos[i] = null;
        }
    }

    public ParamsDataProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = new ParamsDataProcessor(this);
        }
        return this.processor;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public int getBatchCount() {
        return this.position - this.mark;
    }

    public ParamData getCurrentParamData() {
        return this.currentParam;
    }

    public List<ParamData> getParamsCache() {
        return this.paramsCache;
    }

    public void markPosition() {
        this.mark = this.position;
    }

    public void decreaseMark() {
        --this.mark;
    }

    public void setNeedSetInOutType(boolean needSetInOutType) {
        this.needSetInOutType = needSetInOutType;
    }

    public static class ParamInfo {
        public FieldType alignType;
        public boolean needAlign;
    }

    public static class Param {
        public static final int PARAM_NORMAL = 0;
        public static final int PARAM_IN = 64;
        public static final int PARAM_OUT = 128;
        public static final int PARAM_INOUT = 192;
        public FieldType dataType;
        public Object value = null;
        public Calendar calendar = null;
        public int inOutType = 0;
    }

    public static class ParamData {
        final Param[] params;

        ParamData(int paramCount) {
            this.params = new Param[paramCount];
        }

        void setParamValue(int realIndex, FieldType fieldType, Object value) {
            Param p = this.params[realIndex];
            if (p == null) {
                this.params[realIndex] = p = new Param();
            }
            p.dataType = fieldType;
            if (value != null && (fieldType == FieldType.NUMERIC || fieldType == FieldType.DECIMAL)) {
                String bigDecimalStr = value.toString();
                p.value = bigDecimalStr;
            } else {
                p.value = value;
            }
        }

        void setParamCalendar(int realIndex, Calendar cal) {
            Param p = this.params[realIndex];
            if (p == null) {
                this.params[realIndex] = p = new Param();
            }
            p.calendar = cal;
        }

        void setInOutType(int realIndex, int inOutType) {
            Param p = this.params[realIndex];
            p.inOutType |= inOutType;
        }

        void setOutParamType(int realIndex, FieldType fieldType) {
            Param p = this.params[realIndex];
            if (p == null) {
                this.params[realIndex] = p = new Param();
            }
            if ((p.inOutType & 0x40) == 0) {
                p.dataType = fieldType;
            }
            this.setInOutType(realIndex, 128);
        }

        public boolean hasOutParam() {
            boolean result = false;
            for (int i = 0; i < this.params.length; ++i) {
                if ((this.params[i].inOutType & 0x80) == 0) continue;
                result = true;
                break;
            }
            return result;
        }

        public boolean isOutParam(int realIndex) {
            return (this.params[realIndex].inOutType & 0x80) != 0;
        }

        void clear() {
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = null;
            }
        }

        void checkHasNoBindColumn() throws SQLException {
            int index = 0;
            for (Param p : this.params) {
                ++index;
                if (p != null) continue;
                throw ExceptionUtil.illegalJDBCArgumentExceptionWithErrCode("Column [" + index + "] has not binding data.", 506);
            }
        }
    }
}

