/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel.context.statement;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.IntervalDS;
import com.huawei.gauss.channel.context.statement.IntervalYM;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.TimeStampLTZ;
import com.huawei.gauss.jdbc.inner.TimeStampTZ;
import com.huawei.gauss.util.BytesUtil;
import com.huawei.gauss.util.DecimalUtil;
import com.huawei.gauss.util.TimeUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class RowsData {
    public static final int HAS_MORE_ROWS = 1;
    public static final int HAS_NO_MORE_ROWS = 0;
    public static final int BEFORE_FIRST = -1;
    public static final int FIRST_ROW = 0;
    public static final byte FLAG_NULLABLE = 1;
    public static final byte FLAG_AUTO_INCREMENT = 2;
    public static final byte FLAG_CHARACTER = 4;
    public static final RowData[] NULL_ROWS_DATA = new RowData[0];
    public FieldDef[] fieldDefs;
    protected int fieldCount;
    protected FieldDef[] finalDefs;
    protected int rowCount;
    protected RowData[] rows;
    protected boolean hasMoreRows;
    protected int currentRowIndex;
    protected boolean needClear;
    protected final boolean isBigEndianess;
    protected String sql;
    protected Map<String, Integer> columnIndexCache = new HashMap<String, Integer>();
    protected GaussConnection gsConnection;
    static final Map<Class<?>, Object> DEFAULT_NULL_VALUES = new HashMap();

    public RowsData(FieldDef[] fieldDefs, RowData[] rows, int hasMoreRows, ByteOrder order, GaussConnection gsConnection) {
        this(rows, hasMoreRows, order, gsConnection);
        this.fieldCount = fieldDefs.length;
        this.fieldDefs = fieldDefs;
        this.filterHasLob(fieldDefs);
    }

    public RowsData(RowData[] rows, int hasMoreRows, ByteOrder order, GaussConnection gsConnection) {
        this.rowCount = rows.length;
        this.rows = rows;
        this.gsConnection = gsConnection;
        this.needClear = this.hasMoreRows = hasMoreRows == 1;
        this.isBigEndianess = order.equals(ByteOrder.BIG_ENDIAN);
        this.currentRowIndex = -1;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getColumnCount() {
        return this.fieldCount;
    }

    public int getColumnWidth(int columnIndex) throws SQLException {
        this.validIndex(columnIndex);
        return this.fieldDefs[columnIndex - 1].columnWidth;
    }

    public String getColumnName(int columnIndex) throws SQLException {
        this.validIndex(columnIndex);
        return this.fieldDefs[columnIndex - 1].columnName;
    }

    public int getPrecision(int columnIndex) throws SQLException {
        this.validIndex(columnIndex);
        return this.fieldDefs[columnIndex - 1].precision;
    }

    public int getScale(int columnIndex) throws SQLException {
        this.validIndex(columnIndex);
        return this.fieldDefs[columnIndex - 1].scale;
    }

    public FieldType getColumnType(int columnIndex) throws SQLException {
        this.validIndex(columnIndex);
        return this.fieldDefs[columnIndex - 1].fieldType;
    }

    public boolean getIsNotNull(int columnIndex) throws SQLException {
        this.validIndex(columnIndex);
        return this.fieldDefs[columnIndex - 1].notNull;
    }

    public boolean checkLobType(int columnIndex) throws SQLException {
        this.validIndex(columnIndex);
        FieldType type = this.fieldDefs[columnIndex - 1].fieldType;
        return FieldType.BLOB.equals((Object)type) || FieldType.CLOB.equals((Object)type) || FieldType.IMAGE.equals((Object)type);
    }

    private void validIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fieldCount) {
            throw ExceptionUtil.processJDBCException("Index " + columnIndex + " should start from 1 and less than " + this.fieldCount + ".", "S1002", 635);
        }
    }

    private void filterHasLob(FieldDef[] fieldDefs) {
        for (FieldDef def : fieldDefs) {
            FieldType fieldType = def.fieldType;
            if (!FieldType.CLOB.equals((Object)fieldType) && !FieldType.BLOB.equals((Object)fieldType) && !FieldType.IMAGE.equals((Object)fieldType)) continue;
            this.needClear = true;
            break;
        }
    }

    public void setFetchedMoreRows(int rowCount, int hasMoreRows, RowData[] rows) {
        this.rowCount = rowCount;
        this.hasMoreRows = hasMoreRows == 1;
        this.rows = rows;
        this.currentRowIndex = -1;
    }

    public void setFinalDefs(FieldDef[] finalDefs) {
        this.finalDefs = finalDefs;
    }

    public RowData getCurrentRowData() {
        return this.rows[this.currentRowIndex];
    }

    public boolean next() {
        boolean next;
        boolean bl = next = ++this.currentRowIndex < this.rowCount;
        if (!next) {
            --this.currentRowIndex;
        }
        return next;
    }

    public void clear() {
        this.currentRowIndex = -1;
    }

    public <T> T getValue(int fieldIndex, Class<T> desireType, Calendar cal) throws SQLException {
        this.validateCurrentIndex();
        FieldType fieldType = null;
        int realIndex = fieldIndex - 1;
        try {
            fieldType = this.fieldDefs[realIndex].fieldType;
            return this.rows[this.currentRowIndex].getValue(realIndex, fieldType, desireType, this.isBigEndianess, cal, this.gsConnection);
        }
        catch (RuntimeException e) {
            StringBuilder err = new StringBuilder();
            if (fieldType == null) {
                err.append("Column index invalid");
                err.append(", value must between 1 to ").append(this.fieldCount);
                err.append(", but your value is ").append(fieldIndex);
                err.append(".");
                err.append(", sql=").append(this.sql);
            } else {
                err.append("Get column [");
                err.append(this.fieldDefs[realIndex].columnName);
                err.append("] value failed");
                err.append(", cause data type is [");
                err.append(fieldType.getName()).append("]");
                err.append(", but desired data type is [");
                err.append(desireType.getName()).append("].");
                err.append(", sql=").append(this.sql);
            }
            throw ExceptionUtil.processJDBCException(err.toString(), "S1002", 635, e);
        }
    }

    public int getFieldIndex(String fieldName) throws SQLException {
        Integer index = this.columnIndexCache.get(fieldName);
        if (index == null) {
            String upperName = fieldName.toUpperCase(Locale.US);
            index = this.findFieldIndex(upperName) + 1;
            this.columnIndexCache.put(fieldName, index);
        }
        return index;
    }

    private int findFieldIndex(String upperName) throws SQLException {
        int index = -1;
        for (int i = 0; i < this.fieldDefs.length; ++i) {
            String metaName = this.fieldDefs[i].columnName.toUpperCase(Locale.US);
            if (!metaName.equals(upperName)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw ExceptionUtil.processJDBCException("Column [" + upperName + "] not found.", "S0022", 618);
        }
        return index;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean hasMoreRows() {
        return this.hasMoreRows;
    }

    public boolean needClear() {
        return this.needClear;
    }

    public boolean isBeforeFirst() {
        return this.currentRowIndex <= -1 && !this.needClear;
    }

    public boolean isAfterLast() {
        return this.currentRowIndex + 1 >= this.rowCount && !this.hasMoreRows;
    }

    public boolean isFirst() {
        return this.currentRowIndex == 0 && !this.needClear;
    }

    public boolean isLast() {
        return this.currentRowIndex == this.rowCount - 1 && !this.hasMoreRows;
    }

    public void beforeFirst() {
        this.currentRowIndex = -1;
    }

    public void afterLast() {
        this.currentRowIndex = this.rowCount;
    }

    public int getRow() {
        return this.currentRowIndex + 1;
    }

    public boolean wasNull(int fieldIndex) throws SQLException {
        this.validIndex(fieldIndex);
        this.validateCurrentIndex();
        return this.rows[this.currentRowIndex].rowValues[fieldIndex - 1].wasNull();
    }

    public boolean isBigEndianess() {
        return this.isBigEndianess;
    }

    public FieldDef[] getFieldDefs() {
        return this.fieldDefs;
    }

    public void resetFieldDefs(FieldDef[] fieldDefs) {
        this.fieldDefs = fieldDefs;
        this.fieldCount = fieldDefs.length;
        if (this.finalDefs != null) {
            for (FieldDef def : this.finalDefs) {
                FieldDef needUpdateDef = this.fieldDefs[def.finalColumnId];
                needUpdateDef.fieldType = def.fieldType;
                needUpdateDef.columnWidth = def.columnWidth;
                needUpdateDef.precision = def.precision;
                needUpdateDef.scale = def.scale;
            }
        }
    }

    void validateCurrentIndex() throws JDBCException {
        if (this.currentRowIndex <= -1) {
            StringBuilder err = new StringBuilder();
            if (this.rowCount <= 0) {
                err.append("ResultSet is empty, using ResultSet.next() to know whether has data.");
            } else {
                err.append("Plz using ResultSet.next() method to move cursor.");
            }
            throw ExceptionUtil.illegalJDBCArgumentException(err.toString());
        }
        if (this.currentRowIndex >= this.rowCount) {
            throw ExceptionUtil.illegalJDBCArgumentException("CurrentRowIndex need be less than rowCount.");
        }
    }

    static {
        DEFAULT_NULL_VALUES.put(String.class, null);
        DEFAULT_NULL_VALUES.put(BigDecimal.class, null);
        DEFAULT_NULL_VALUES.put(byte[].class, null);
        DEFAULT_NULL_VALUES.put(Date.class, null);
        DEFAULT_NULL_VALUES.put(Time.class, null);
        DEFAULT_NULL_VALUES.put(Timestamp.class, null);
        DEFAULT_NULL_VALUES.put(Boolean.class, false);
        DEFAULT_NULL_VALUES.put(Byte.class, (byte)0);
        DEFAULT_NULL_VALUES.put(Short.class, (short)0);
        DEFAULT_NULL_VALUES.put(Integer.class, 0);
        DEFAULT_NULL_VALUES.put(Long.class, 0L);
        DEFAULT_NULL_VALUES.put(Float.class, Float.valueOf(0.0f));
        DEFAULT_NULL_VALUES.put(Double.class, 0.0);
    }

    public static final class FieldValue {
        private Object value;
        private final int length;
        private final byte[] b;

        public FieldValue(int length, byte[] b) {
            this.length = length;
            this.b = b;
        }

        public FieldValue() {
            this.length = -1;
            this.b = null;
        }

        public FieldValue(Object value) {
            this.value = value;
            this.length = 0;
            this.b = null;
        }

        boolean wasNull() {
            return this.length < 0;
        }

        public <T> T getValue(FieldType fieldType, Class<T> desireType, boolean isBigEndianess, Calendar cal, GaussConnection conn) throws SQLException {
            if (this.length >= 0) {
                this.toValue(fieldType, isBigEndianess, cal, conn);
            }
            return this.getDesiredValue(fieldType, desireType);
        }

        private <T> T getDesiredValue(FieldType fieldType, Class<T> desireType) throws SQLException {
            if (this.length < 0) {
                return (T)DEFAULT_NULL_VALUES.get(desireType);
            }
            if (desireType.equals(String.class)) {
                if (this.value instanceof TimeStampLTZ) {
                    return (T)((TimeStampLTZ)this.value).getStringValue();
                }
                return (T)String.valueOf(this.value);
            }
            if (desireType.equals(Integer.class)) {
                return (T)this.getIntValue(fieldType);
            }
            if (desireType.equals(Boolean.class)) {
                return (T)this.getBooleanValue();
            }
            if (desireType.equals(Byte.class)) {
                return (T)this.getByteValue();
            }
            if (desireType.equals(Short.class)) {
                return (T)this.getShortValue();
            }
            if (desireType.equals(Long.class)) {
                return (T)this.getLongValue();
            }
            if (desireType.equals(Float.class)) {
                return (T)this.getFloatValue();
            }
            if (desireType.equals(Double.class)) {
                return (T)this.getDoubleValue();
            }
            if (desireType.equals(BigDecimal.class)) {
                String stringValue = String.valueOf(this.value);
                return (T)new BigDecimal(stringValue);
            }
            if (desireType.equals(byte[].class)) {
                if (this.value instanceof byte[]) {
                    return (T)this.value;
                }
                throw new IllegalArgumentException("Value is not bytes type.");
            }
            if (desireType.equals(Date.class)) {
                if (this.value instanceof Date) {
                    return (T)this.value;
                }
                if (this.value instanceof java.util.Date) {
                    return (T)new Date(((java.util.Date)this.value).getTime());
                }
                if (this.value instanceof TimeStampTZ) {
                    return (T)new Date(((TimeStampTZ)this.value).getTimestamp().getTime());
                }
                if (this.value instanceof TimeStampLTZ) {
                    return (T)new Date(((TimeStampLTZ)this.value).getTimeStamp().getTime());
                }
                return (T)Date.valueOf(this.value.toString());
            }
            if (desireType.equals(Time.class)) {
                if (this.value instanceof Time) {
                    return (T)this.value;
                }
                if (this.value instanceof java.util.Date) {
                    return (T)new Time(((java.util.Date)this.value).getTime());
                }
                if (this.value instanceof TimeStampTZ) {
                    return (T)new Time(((TimeStampTZ)this.value).getTimestamp().getTime());
                }
                if (this.value instanceof TimeStampLTZ) {
                    return (T)new Time(((TimeStampLTZ)this.value).getTimeStamp().getTime());
                }
                return (T)Time.valueOf(this.value.toString());
            }
            if (desireType.equals(Timestamp.class)) {
                if (this.value instanceof Timestamp) {
                    return (T)this.value;
                }
                if (this.value instanceof java.util.Date) {
                    return (T)new Timestamp(((java.util.Date)this.value).getTime());
                }
                if (this.value instanceof TimeStampTZ) {
                    return (T)((TimeStampTZ)this.value).getTimestamp();
                }
                if (this.value instanceof TimeStampLTZ) {
                    return (T)((TimeStampLTZ)this.value).getTimeStamp();
                }
                return (T)Timestamp.valueOf(this.value.toString());
            }
            if (desireType.equals(Clob.class)) {
                throw new IllegalArgumentException("Clob type is exceptional data type.");
            }
            if (desireType.equals(Blob.class)) {
                throw new IllegalArgumentException("Blob type is exceptional data type.");
            }
            return (T)this.value;
        }

        private Boolean getBooleanValue() {
            try {
                BigDecimal number = new BigDecimal(this.value.toString());
                return number.floatValue() != 0.0f;
            }
            catch (Exception ingnore) {
                return Boolean.valueOf(this.value.toString());
            }
        }

        private Long getLongValue() throws JDBCException {
            BigDecimal rs = new BigDecimal(this.value.toString());
            if (rs.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0 || rs.compareTo(new BigDecimal(Long.MIN_VALUE)) < 0) {
                throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Long");
            }
            return new BigDecimal(this.value.toString()).longValue();
        }

        private Integer getIntValue(FieldType fieldType) throws JDBCException {
            BigDecimal rs = new BigDecimal(this.value.toString());
            if (rs.compareTo(new BigDecimal(Integer.MAX_VALUE)) > 0 || rs.compareTo(new BigDecimal(Integer.MIN_VALUE)) < 0) {
                throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Integer");
            }
            return new BigDecimal(this.value.toString()).intValue();
        }

        private Byte getByteValue() throws JDBCException {
            if (this.value instanceof Number) {
                BigDecimal rs = new BigDecimal(this.value.toString());
                if (rs.compareTo(new BigDecimal(127)) > 0 || rs.compareTo(new BigDecimal(-128)) < 0) {
                    throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Byte");
                }
                return ((Number)this.value).byteValue();
            }
            try {
                return Byte.valueOf(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Byte");
            }
        }

        private Short getShortValue() throws JDBCException {
            if (this.value instanceof Number) {
                BigDecimal rs = new BigDecimal(this.value.toString());
                if (rs.compareTo(new BigDecimal(Short.MAX_VALUE)) > 0 || rs.compareTo(new BigDecimal(Short.MIN_VALUE)) < 0) {
                    throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Short");
                }
                return ((Number)this.value).shortValue();
            }
            try {
                return Short.valueOf(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Short");
            }
        }

        private Float getFloatValue() throws JDBCException {
            try {
                return Float.valueOf(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Float");
            }
        }

        private Double getDoubleValue() throws JDBCException {
            try {
                return Double.valueOf(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw ExceptionUtil.numberRangeOutOfBoundsException("column value: [" + this.value.toString() + "] is outside of valid range for type java.lang.Double");
            }
        }

        private void toValue(FieldType fieldType, boolean isBigEndianess, Calendar cal, GaussConnection conn) throws SQLException {
            switch (fieldType) {
                case NUMERIC: 
                case DECIMAL: {
                    try {
                        DecimalUtil.Decimal dec = new DecimalUtil.Decimal(this.b, this.length, isBigEndianess);
                        this.value = dec.toString();
                        break;
                    }
                    catch (Exception e) {
                        throw new SQLException(e.toString());
                    }
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    this.value = BytesUtil.toString(Arrays.copyOf(this.b, this.length));
                    break;
                }
                case INTEGER: 
                case BOOLEAN: {
                    this.value = BytesUtil.toInt(this.b, isBigEndianess);
                    break;
                }
                case UINT32: {
                    this.value = BytesUtil.toUnsignedInt(this.b, 0, isBigEndianess);
                    break;
                }
                case CURSOR: 
                case BIGINT: {
                    this.value = BytesUtil.toLong(this.b, isBigEndianess);
                    break;
                }
                case REAL: {
                    this.value = BytesUtil.toDouble(this.b);
                    break;
                }
                case DATE_NOTIME: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case TIMESTAMP_TZ_FAKE: 
                case UTC: {
                    long tmpValue = BytesUtil.toLong(this.b, isBigEndianess);
                    this.value = TimeUtil.decodeDate(tmpValue, cal);
                    break;
                }
                case TIMESTAMP_LTZ: {
                    this.value = new TimeStampLTZ(conn, BytesUtil.toLong(this.b, isBigEndianess), cal);
                    break;
                }
                case TIMESTAMP_TZ: {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(this.b);
                    byteBuffer.order(isBigEndianess ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                    this.value = new TimeStampTZ(byteBuffer.getLong(), byteBuffer.getShort(), conn, cal);
                    break;
                }
                case VARBINARY: 
                case BINARY: 
                case RAW: 
                case BLOB: 
                case CLOB: 
                case IMAGE: {
                    this.value = Arrays.copyOf(this.b, this.length);
                    break;
                }
                case INTERVAL_YM: {
                    long ymitvl = BytesUtil.toInt(this.b, isBigEndianess);
                    this.value = new IntervalYM(ymitvl);
                    break;
                }
                case INTERVAL_DS: {
                    long dsitvl = BytesUtil.toLong(this.b, isBigEndianess);
                    this.value = new IntervalDS(dsitvl);
                    break;
                }
            }
        }
    }

    public static final class FieldDef {
        String columnName;
        FieldType fieldType;
        int columnWidth;
        int precision;
        int scale;
        int columnNameLen;
        boolean notNull;
        int finalColumnId;
        boolean isAutoIncrement;
        boolean isCharacter;
        int reserved;

        public FieldDef() {
        }

        public FieldDef(ByteBuffer buffer, boolean isFinalColumnDefs) throws SQLException {
            if (isFinalColumnDefs) {
                this.decodeFinalColumnDefs(buffer);
            } else {
                this.decodeColumnDefs(buffer);
            }
        }

        public String getColumnName() {
            return this.columnName;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        public int getColumnNameLen() {
            return this.columnNameLen;
        }

        public boolean isNotNull() {
            return this.notNull;
        }

        public void setFieldType(FieldType fieldType) {
            this.fieldType = fieldType;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        private void decodeColumnDefs(ByteBuffer buffer) throws SQLException {
            this.columnWidth = buffer.getShort();
            this.precision = buffer.get();
            this.scale = buffer.get();
            short gsType = buffer.getShort();
            this.fieldType = FieldType.getFieldType(gsType);
            byte flag = buffer.get();
            this.notNull = (flag & 1) == 0;
            this.isAutoIncrement = (flag & 2) != 0;
            this.isCharacter = (flag & 4) != 0;
            buffer.get();
            this.reserved = buffer.getShort();
            this.columnNameLen = buffer.getShort();
            int align4BytesColumnLen = BytesUtil.align4BytesLength(this.columnNameLen);
            byte[] name = new byte[align4BytesColumnLen];
            buffer.get(name);
            this.columnName = BytesUtil.toString(name);
        }

        private void decodeFinalColumnDefs(ByteBuffer buffer) throws SQLException {
            this.finalColumnId = buffer.getShort();
            this.columnWidth = buffer.getShort();
            this.precision = buffer.get();
            this.scale = buffer.get();
            short gsType = buffer.getShort();
            this.fieldType = FieldType.getFieldType(gsType);
        }

        public boolean isAutoIncrement() {
            return this.isAutoIncrement;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.isAutoIncrement = autoIncrement;
        }

        public boolean isCharacter() {
            return this.isCharacter;
        }

        public void setCharacter(boolean character) {
            this.isCharacter = character;
        }

        public int getReserved() {
            return this.reserved;
        }

        public void setReserved(int reserved) {
            this.reserved = reserved;
        }
    }

    public static final class RowData {
        FieldValue[] rowValues;

        public RowData(FieldValue[] rowValues) {
            this.rowValues = rowValues;
        }

        public <T> T getValue(int fieldIndex, FieldType fieldType, Class<T> desireType, boolean isBigEndianess, Calendar cal, GaussConnection conn) throws SQLException {
            return this.rowValues[fieldIndex].getValue(fieldType, desireType, isBigEndianess, cal, conn);
        }

        public void setValue(int fieldIndex, FieldValue value) {
            this.rowValues[fieldIndex] = value;
        }
    }
}

