/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.cluster;

import com.huawei.gauss.cluster.api.GaussCluster;
import com.huawei.gauss.cluster.api.GaussClusterBuilder;
import com.huawei.gauss.cluster.imp.CnBuilder;
import com.huawei.gauss.exception.ClusterException;
import com.huawei.gauss.exception.ExceptionUtil;

public class ClusterFactory {
    private static final String CLS_ETCD_BUD = "com.huawei.gauss.etcd.EtcdClusterBuilder";
    private static final Object LOCK_OBJECT = new Object();
    private static volatile GaussClusterBuilder etcdBuiler = null;

    public static GaussCluster createClusterEntry(String clusterUrl) throws ClusterException {
        return ClusterFactory.createCn(clusterUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GaussCluster createEtcd(String clusterUrl) throws ClusterException {
        if (etcdBuiler == null) {
            Object object = LOCK_OBJECT;
            synchronized (object) {
                if (etcdBuiler == null) {
                    try {
                        Class<?> etcdBuilderClz = Class.forName(CLS_ETCD_BUD);
                        etcdBuiler = (GaussClusterBuilder)etcdBuilderClz.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw ExceptionUtil.processClusterException("can't load etcd builder, may etcd jar not in classpath, builder class: [com.huawei.gauss.etcd.EtcdClusterBuilder]", e);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw ExceptionUtil.processClusterException("get etcdBuilder object failed", e);
                    }
                }
            }
        }
        return etcdBuiler.build(clusterUrl);
    }

    private static GaussCluster createCn(String clusterUrl) throws ClusterException {
        return new CnBuilder().build(clusterUrl);
    }
}

