/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.cluster;

import com.huawei.gauss.cluster.api.ClusterNodeStatus;
import com.huawei.gauss.cluster.api.ClustserPropKeys;
import com.huawei.gauss.cluster.api.GaussClusterNode;
import com.huawei.gauss.cluster.check.GaussNodeHealthDetector;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussInfoImpl;
import com.huawei.gauss.jdbc.inner.GaussSubDriverAbstract;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterNodeImp
extends GaussInfoImpl
implements GaussClusterNode {
    private static final ClusterNodeStatus DEFAULT_STATUS = ClusterNodeStatus.ONLINE;
    private String cnClusterName;
    private String status = DEFAULT_STATUS.getValue();
    private AtomicBoolean lastCheckResult = new AtomicBoolean(true);
    private final AtomicInteger establishedCount = new AtomicInteger(0);

    public ClusterNodeImp() {
        this.isCluster = true;
    }

    public ClusterNodeImp(String url) throws SQLException {
        String[] ipPorts = this.parseUrl(url);
        this.initBaseInfo(ipPorts);
        this.setCnClusterName(ipPorts[0]);
        this.isCluster = true;
    }

    @Override
    public synchronized void initBaseInfo(String[] ipPorts) {
        this.setNodeIp(ipPorts[0]);
        this.setNodePort(ipPorts[1]);
        this.setIpAndPort(ipPorts[0] + ":" + ipPorts[1]);
    }

    @Override
    public String getCnClusterName() {
        return this.cnClusterName;
    }

    @Override
    public void setCnClusterName(String clusterName) {
        this.cnClusterName = clusterName;
    }

    @Override
    public boolean checkOk() {
        this.lastCheckResult.set(GaussNodeHealthDetector.isOk(this.getIpAndPort()));
        return this.lastCheckResult.get();
    }

    @Override
    public void decreaseConnCount() {
        this.establishedCount.decrementAndGet();
    }

    @Override
    public void increaseConnCount() {
        this.establishedCount.incrementAndGet();
    }

    @Override
    public int getEstablishedCount() {
        return this.establishedCount.get();
    }

    @Override
    public boolean isOk() {
        return this.lastCheckResult.get();
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public GaussConnectionImpl createConnection(GaussSubDriverAbstract driver, Properties props) throws SQLException {
        try {
            return super.createConnection(driver, props);
        }
        catch (SQLException e) {
            this.decreaseConnCount();
            throw e;
        }
    }

    @Override
    public void refreshNodeInfo(Properties props) {
        this.setStatus(props.getProperty(ClustserPropKeys.K_STATUS.getValue(), DEFAULT_STATUS.getValue()));
        this.setCnClusterName(props.getProperty(ClustserPropKeys.K_CLS_NAME.getValue(), this.getIpAndPort()));
    }

    @Override
    public String toString() {
        return "ClusterNodeInfo:{isCluster=[" + this.isCluster + "], ipAndPort=[" + this.ipAndPort + "], originalUrl=[" + this.originalUrl + "], status=[" + this.status + "], lastCheckResult=[" + this.lastCheckResult + "], establishedCount=[" + this.establishedCount + "]}";
    }
}

