/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.cluster;

import com.huawei.gauss.cluster.ClusterFactory;
import com.huawei.gauss.cluster.api.GaussCluster;
import com.huawei.gauss.exception.ClusterException;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussSubDriverAbstract;
import com.huawei.gauss.jdbc.inner.UrlType;
import com.huawei.gauss.util.FormatTransfer;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class GaussClusterManager {
    protected final Map<String, GaussCluster> cnClusterInfos = new ConcurrentHashMap<String, GaussCluster>(1);

    private GaussClusterManager() {
    }

    public static GaussClusterManager getInstance() {
        return GaussClusterManagerInstance.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GaussCluster getClusterInfo(String clusterUrl) throws ClusterException {
        GaussCluster clusterInfo = this.cnClusterInfos.get(clusterUrl);
        if (clusterInfo == null) {
            Map<String, GaussCluster> map = this.cnClusterInfos;
            synchronized (map) {
                clusterInfo = this.cnClusterInfos.get(clusterUrl);
                if (clusterInfo == null) {
                    clusterInfo = ClusterFactory.createClusterEntry(clusterUrl);
                    this.cnClusterInfos.put(clusterUrl, clusterInfo);
                }
            }
        }
        return clusterInfo;
    }

    public GaussConnectionImpl getConnection(GaussSubDriverAbstract driver, String clusterUrl, Properties props, UrlType urlType, List<String> excludedUrls) throws SQLException {
        GaussCluster clusterInfo = this.getClusterInfo(clusterUrl);
        return clusterInfo.getConnection(driver, props, urlType, excludedUrls);
    }

    public String toString() {
        return "GaussClusterManager:CNClusterInfos{" + System.lineSeparator() + FormatTransfer.map2String(this.cnClusterInfos) + '}';
    }

    public void detectAllClusters() {
        for (GaussCluster gc : this.cnClusterInfos.values()) {
            gc.detect();
        }
    }

    public void refreshAllClustersNodesStatus() {
        for (GaussCluster gc : this.cnClusterInfos.values()) {
            gc.refreshNodesStatus();
        }
    }

    private static class GaussClusterManagerInstance {
        public static final GaussClusterManager INSTANCE = new GaussClusterManager();

        private GaussClusterManagerInstance() {
        }
    }
}

