/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.exception;

import com.huawei.gauss.exception.ClusterException;
import com.huawei.gauss.exception.GaussException;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.util.IOUtils;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static JDBCException processJDBCException(String reason) {
        return new JDBCException(reason);
    }

    public static JDBCException processJDBCException(String reason, String sqlState, int errCode) {
        return new JDBCException(reason, sqlState, errCode);
    }

    public static JDBCException processJDBCException(String reason, String sqlState, int errCode, Throwable throwable) {
        if (throwable instanceof JDBCException) {
            return (JDBCException)throwable;
        }
        return new JDBCException(reason + ", detail: " + throwable, sqlState, errCode, throwable);
    }

    public static JDBCException createJDBCException(String reason, String sqlState, int errCode, Throwable throwable) {
        if (!(throwable instanceof JDBCException)) {
            reason = reason + ", detail: " + throwable;
        }
        return new JDBCException(reason, sqlState, errCode, throwable);
    }

    public static GaussException processGaussException(String reason, String sqlState, int errCode) {
        return new GaussException(reason, sqlState, errCode);
    }

    public static SQLException notSupportedFeature(String msg) {
        return new SQLFeatureNotSupportedException(msg + IOUtils.getLocalIp(), "0A000", 513);
    }

    public static JDBCException objectIsNullException(String msg) {
        return ExceptionUtil.processJDBCException(msg, "S1009", 512);
    }

    public static JDBCException connectionClosedException(String msg) {
        return ExceptionUtil.processJDBCException(msg, "S1009", 514);
    }

    public static JDBCException illegalJDBCArgumentException(String msg) {
        return ExceptionUtil.processJDBCException(msg, "S1009", 500);
    }

    public static JDBCException illegalJDBCArgumentException(String msg, Throwable throwable) {
        return ExceptionUtil.processJDBCException(msg, "S1009", 500, throwable);
    }

    public static JDBCException illegalJDBCArgumentExceptionWithErrCode(String msg, int errCode) {
        return ExceptionUtil.processJDBCException(msg, "S1009", errCode);
    }

    public static void handleUnThrowException(String msg, Throwable t) {
    }

    public static JDBCException numberRangeOutOfBoundsException(String msg) {
        return ExceptionUtil.processJDBCException("number out of range, " + msg);
    }

    public static ClusterException processClusterException(String reason, Throwable throwable) {
        if (!(throwable instanceof JDBCException)) {
            reason = reason + ", detail: " + throwable;
        }
        return new ClusterException(reason, throwable);
    }

    public static ClusterException processClusterException(String msg) {
        return new ClusterException(msg);
    }

    public static JDBCException createClusterException(String reason, String sqlState, int errCode, Throwable throwable) {
        if (!(throwable instanceof JDBCException)) {
            reason = reason + ", detail: " + throwable;
        }
        return new ClusterException(reason, sqlState, errCode, throwable);
    }

    public static SQLException createClusterException(String reason, String sqlState, int errCode) {
        return new ClusterException(reason, sqlState, errCode);
    }
}

