/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.exception;

import com.huawei.gauss.util.IOUtils;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GaussException
extends SQLException {
    protected static final int INVALID_SESSION_ID = -1;
    private static final long serialVersionUID = 477816283856688396L;
    private static final Pattern DATASOURCE_PATTERN = Pattern.compile("((CREATE|ALTER)\\s{1,}DATASOURCE\\s{1,}.+?\\s).+?");
    protected String sql;
    protected String serverIp;
    protected int sessionId = -1;

    public GaussException(String reason) {
        super(reason);
    }

    public GaussException(String reason, String sqlState, int errCode) {
        super(reason, sqlState, errCode);
    }

    public GaussException(String reason, String sqlState, int errCode, Throwable cause) {
        super(reason, sqlState, errCode, cause);
    }

    public GaussException(String reason, Throwable cause) {
        super(reason, cause);
    }

    @Override
    public String getMessage() {
        StringBuilder sBuilder = new StringBuilder("[errorCode=");
        int errCode = this.getErrorCode();
        if (errCode == 0) {
            errCode = 500;
        }
        sBuilder.append("GS-" + new DecimalFormat("00000").format(errCode));
        if (this.getSQLState() != null) {
            sBuilder.append(", SQLState='").append(this.getSQLState());
        }
        sBuilder.append("', reason='");
        sBuilder.append(super.getMessage()).append("'");
        if (this.sql != null) {
            sBuilder.append(", sql=").append(this.sql);
        }
        if (this.sessionId > -1) {
            sBuilder.append(", sessionId=").append(this.sessionId);
        }
        sBuilder.append(this.getIpInfo());
        sBuilder.append("]\n");
        for (Throwable cause = this.getCause(); cause != null; cause = cause.getCause()) {
            sBuilder.append(" <-- ");
            sBuilder.append(cause.getMessage());
        }
        return sBuilder.toString();
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public void setZenithServerIp(String serverIpIn) {
        this.serverIp = serverIpIn;
    }

    public void setSql(String sql) {
        if (sql != null) {
            String upperSql = sql.toUpperCase(Locale.US).trim();
            Matcher matcher = DATASOURCE_PATTERN.matcher(upperSql);
            this.sql = matcher.matches() ? sql.substring(0, matcher.group(1).length()) + "..." : sql;
        }
    }

    protected String getIpInfo() {
        StringBuilder sBuilder = new StringBuilder();
        if (this.serverIp != null) {
            sBuilder.append(", serverIP=").append(this.serverIp);
        }
        sBuilder.append(", clientIP=").append(IOUtils.getLocalIp()).append(".");
        return sBuilder.toString();
    }
}

