/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.connection.inner;

import com.huawei.gauss.channel.CHandlerContext;
import com.huawei.gauss.channel.context.connection.CloseConnectionContext;
import com.huawei.gauss.channel.context.connection.CommitContext;
import com.huawei.gauss.channel.context.connection.CreateStatementContext;
import com.huawei.gauss.channel.context.connection.PrepareCallContext;
import com.huawei.gauss.channel.context.connection.PrepareStatementContext;
import com.huawei.gauss.channel.context.connection.ReleaseSavepointContext;
import com.huawei.gauss.channel.context.connection.RollbackContext;
import com.huawei.gauss.channel.context.connection.SetSavepointContext;
import com.huawei.gauss.channel.context.connection.XAcommitContext;
import com.huawei.gauss.channel.context.connection.XAendContext;
import com.huawei.gauss.channel.context.connection.XAprepareContext;
import com.huawei.gauss.channel.context.connection.XArollbackContext;
import com.huawei.gauss.channel.context.connection.XAstartContext;
import com.huawei.gauss.channel.context.statement.CloseStmtContext;
import com.huawei.gauss.handler.connection.DefaultConnectionCHandler;
import com.huawei.gauss.handler.inner.ParamValidateCHandlerHelper;
import com.huawei.gauss.jdbc.IGaussDriver;
import com.huawei.gauss.util.lang.StringUtils;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class ConnParamValidateCHandler
extends DefaultConnectionCHandler {
    private final ParamValidateCHandlerHelper paramValidateCHandlerHelper = new ParamValidateCHandlerHelper();

    public ConnParamValidateCHandler(IGaussDriver gaussDriver) {
        super(gaussDriver);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(CloseConnectionContext closeConnectionContext) throws SQLException {
        if (closeConnectionContext.getGaussConnection().isClosed()) {
            return CHandlerContext.ProcessState.RETURN;
        }
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(CommitContext commitContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(commitContext);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(CreateStatementContext context) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(context);
        if (this.configManager.getUCheckFeatureNotSupported() && (context.getResultSetType() != 1003 || context.getResultSetConcurrency() != 1007 || context.getResultSetHoldability() != context.getGaussConnection().getHoldability())) {
            throw new SQLFeatureNotSupportedException("Not support create statement with context: " + context, "0A000", 513);
        }
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(PrepareCallContext context) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(context);
        if (StringUtils.isEmpty(context.getSql())) {
            throw new SQLException("Prepare SQL is empty : " + context.getSql(), "S1009", 512);
        }
        if (this.configManager.getUCheckFeatureNotSupported() && (context.getResultSetType() != 1003 || context.getResultSetConcurrency() != 1007 || context.getResultSetHoldability() != context.getGaussConnection().getHoldability() || context.getResultSetHoldability() != 2)) {
            throw new SQLFeatureNotSupportedException("Not support create prepareCall with context: " + context, "0A000", 513);
        }
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(PrepareStatementContext prepareStmtContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(prepareStmtContext);
        if (StringUtils.isEmpty(prepareStmtContext.getSql())) {
            throw new SQLException("Prepare SQL is empty : " + prepareStmtContext.getSql(), "S1009", 512);
        }
        if (this.configManager.getUCheckFeatureNotSupported() && (prepareStmtContext.getResultSetType() != 1003 || prepareStmtContext.getResultSetConcurrency() != 1007 || prepareStmtContext.getResultSetHoldability() != prepareStmtContext.getGaussConnection().getHoldability())) {
            throw new SQLFeatureNotSupportedException("Not support create prepareStatement with context: " + prepareStmtContext, "0A000", 513);
        }
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(ReleaseSavepointContext releaseSavepointContext) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("ReleaseSavepoint has not been supported.", "0A000", 513);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(RollbackContext rollbackContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(rollbackContext);
        if (this.configManager.getUCheckFeatureNotSupported() && null != rollbackContext.getSavepoint()) {
            throw new SQLFeatureNotSupportedException("Not support rollback with savepoint", "0A000", 513);
        }
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(SetSavepointContext setSavepointContext) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not support setSavepoint", "0A000", 513);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(CloseStmtContext closeStmtContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(closeStmtContext);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAprepareContext xaPrepareContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(xaPrepareContext);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAcommitContext xaCommitContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(xaCommitContext);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XArollbackContext xaRollbackContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(xaRollbackContext);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAstartContext xaStartContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(xaStartContext);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAendContext xaEndContext) throws SQLException {
        this.paramValidateCHandlerHelper.validateConnection(xaEndContext);
        return CHandlerContext.ProcessState.CONTINUE;
    }
}

