/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.inner;

import com.huawei.gauss.channel.CHandlerContext;
import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.channel.context.connection.DoConnectContext;
import com.huawei.gauss.channel.context.statement.AbstractExecuteContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.GaussException;
import com.huawei.gauss.handler.connection.inner.ConnGmdbMsgProcessCHandler;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.handler.inner.IOClientImpl;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractMessage;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.jdbc.inner.message.gmdb.HandshakeResponse;
import com.huawei.gauss.om.ConfigManager;
import com.huawei.gauss.util.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class GmdbMessageProcessHelper {
    private final ConfigManager configManager;

    public GmdbMessageProcessHelper(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public CHandlerContext.ProcessState doExecute(AbstractCommonRequest request) throws SQLException {
        IOClientImpl ioClient = (IOClientImpl)request.getConnection().getIOClient();
        ioClient.lockIOClient();
        try {
            this.sendMessage(request);
        }
        finally {
            ioClient.unlockIOClient();
        }
        return CHandlerContext.ProcessState.CONTINUE;
    }

    public CHandlerContext.ProcessState doExecute(AbstractCommonRequest request, AbstractCommonResponse response) throws SQLException {
        IOClientImpl ioClient = (IOClientImpl)request.getConnection().getIOClient();
        this.sendAndWaitMessage(request, response);
        if (response != null && response.isError()) {
            int sessionId = ioClient.getSessionId();
            GaussException exception = ExceptionUtil.processGaussException(response.getErrorMsg() + ",ioClient:@" + Integer.toHexString(ioClient.hashCode()), "28000", response.getErrCode());
            DefaultCHandlerContext<?> context = request.getContext();
            if (context instanceof AbstractExecuteContext) {
                exception.setSql(((AbstractExecuteContext)context).getSql());
            }
            exception.setSessionId(sessionId);
            exception.setZenithServerIp(ioClient.getZenithUrl());
            throw exception;
        }
        return CHandlerContext.ProcessState.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractCommonResponse> void getMessage(T msg) throws SQLException {
        boolean hasReturnResultSet;
        do {
            ByteBuffer bodyByteBuffer;
            block5: {
                hasReturnResultSet = false;
                bodyByteBuffer = null;
                IOClient ioClient = msg.getConnection().getIOClient();
                try {
                    boolean needDecode;
                    ByteBuffer byteBuffer = ByteBuffer.allocate(16);
                    byteBuffer.order(ioClient.getByteOrder());
                    ioClient.read(byteBuffer);
                    byteBuffer.rewind();
                    msg.decodeFixHeader(byteBuffer);
                    hasReturnResultSet = msg.getFixHeader().hasReturnResultSet();
                    AbstractMessage.FixHeader fixHeader = msg.getFixHeader();
                    int remainLen = fixHeader.getOptionHeadAndBodyLen();
                    bodyByteBuffer = ByteBufferUtil.getDirectByteBuffer(remainLen);
                    bodyByteBuffer.order(ioClient.getByteOrder());
                    ioClient.read(bodyByteBuffer);
                    bodyByteBuffer.rewind();
                    int currentSerialNum = ioClient.currentSerialNumber();
                    boolean bl = needDecode = fixHeader.getSerialNumber() == currentSerialNum;
                    if (!needDecode) break block5;
                    if (hasReturnResultSet) {
                        long cursor = bodyByteBuffer.getLong();
                        DefaultCHandlerContext<?> context = msg.getContext();
                        if (context instanceof AbstractExecuteContext) {
                            ((AbstractExecuteContext)context).addOneReturnResultSet(cursor);
                        }
                        this.simpleResponseToServer(ioClient);
                        break block5;
                    }
                    msg.decodeBody(bodyByteBuffer, msg.getConnection().getZenithInfo());
                }
                catch (Throwable throwable) {
                    ByteBufferUtil.releaseDirectByteBuffer(bodyByteBuffer);
                    bodyByteBuffer = null;
                    throw throwable;
                }
            }
            ByteBufferUtil.releaseDirectByteBuffer(bodyByteBuffer);
            bodyByteBuffer = null;
        } while (hasReturnResultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1 extends AbstractCommonRequest, T2 extends AbstractCommonResponse> void sendAndWaitMessage(T1 request, T2 response) throws SQLException {
        IOClientImpl ioClient = (IOClientImpl)request.getConnection().getIOClient();
        ioClient.lockIOClient();
        try {
            this.sendMessage(request);
            this.getMessage(response);
            int recvSerialNum = response.getFixHeader().getSerialNumber();
            int currentSerialNum = ioClient.currentSerialNumber();
            while (recvSerialNum != currentSerialNum) {
                if (recvSerialNum > currentSerialNum) {
                    GaussException exception = ExceptionUtil.processGaussException("Package serial number error. recvSerialNum=" + recvSerialNum + ",currentSerialNum=" + currentSerialNum + ".", "28000", response.getErrCode());
                    exception.setSessionId(ioClient.getSessionId());
                    exception.setZenithServerIp(ioClient.getZenithUrl());
                    throw exception;
                }
                this.getMessage(response);
                recvSerialNum = response.getFixHeader().getSerialNumber();
            }
        }
        finally {
            ioClient.unlockIOClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractCommonRequest> void sendMessage(T msg) throws SQLException {
        msg.prepareSerialNumber();
        IOClient ioClient = msg.getConnection().getIOClient();
        DynamicByteBuffer encodeBuffer = null;
        try {
            encodeBuffer = msg.encode(this.configManager.getBufferSegmentSize());
            ioClient.write(encodeBuffer);
        }
        finally {
            if (null != encodeBuffer) {
                encodeBuffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractCommonRequest> void sendCloseConnMessage(T msg) throws SQLException {
        IOClientImpl ioClient = (IOClientImpl)msg.getConnection().getIOClient();
        ioClient.lockIOClient();
        msg.prepareSerialNumber();
        DynamicByteBuffer encodeBuffer = null;
        try {
            encodeBuffer = msg.encode(this.configManager.getBufferSegmentSize());
            ioClient.write(encodeBuffer);
        }
        finally {
            ioClient.unlockIOClient();
            if (null != encodeBuffer) {
                encodeBuffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendloginMessage(ConnGmdbMsgProcessCHandler conGmdbHandler, DoConnectContext context) throws SQLException {
        IOClientImpl ioClient = (IOClientImpl)context.getGaussConnection().getIOClient();
        ioClient.lockIOClient();
        try {
            int flags = conGmdbHandler.doGSQLProtocolDiag();
            HandshakeResponse ack = conGmdbHandler.doHandshake(flags, context);
            conGmdbHandler.doGaussLogin(context, ack);
        }
        finally {
            ioClient.unlockIOClient();
        }
    }

    public void simpleResponseToServer(IOClient ioClient) throws SQLException {
        ByteBuffer reponse = ByteBuffer.allocate(16);
        reponse.order(ioClient.getByteOrder());
        AbstractMessage.simpleRequestPacket(reponse);
        ioClient.write(reponse);
    }
}

