/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.handler.inner.IOClientSSL;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.om.ConfigManager;
import com.huawei.gauss.om.OMConstants;
import com.huawei.gauss.util.IOUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocket;

public class IOClientImpl
implements IOClient,
OMConstants {
    SSLSocket sslSocket;
    InputStream sslInput;
    BufferedOutputStream sslOutput;
    private ConfigManager configManager;
    private SocketAddress remoteAddress;
    private int port;
    private String ipaddr;
    private SocketChannel socketChannel;
    private ReadableByteChannel soInput;
    private final ReentrantLock ioLock = new ReentrantLock();
    private int sessionSeqNo;
    private int serialNumber;
    private int gaussConnectionId;
    private int sessionId = -1;
    private boolean isBigEndian;
    private ByteOrder order = ByteOrder.LITTLE_ENDIAN;
    private int loginTimeout = 0;
    private int socketTimeout = 0;
    private int locatorSize = 0;
    private int charset = 0;
    private int maxAllowedPacket = 0;
    private int clientFlag;
    private int serverCapabilities;
    private boolean useSSL;
    private boolean requireSSL;
    private boolean verifyServerCert;
    private boolean isRevocationEnabled;
    private int callVersion;
    private int serverVersion;
    private String sslCiphers;
    private Integer severDBTimezone = null;
    private Integer clientSessionTimezone = null;
    private TimeZone defaultJVMTimeZone = null;
    private Calendar defaultJVMCalendar = null;

    protected IOClientImpl(ConfigManager configManager, SocketAddress remoteAddress) {
        this.configManager = configManager;
        this.remoteAddress = remoteAddress;
        if (this.remoteAddress != null) {
            InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
            this.ipaddr = socketAddress.getAddress().getHostAddress();
            this.port = socketAddress.getPort();
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.socketChannel);
        if (this.sslSocket != null) {
            this.closeSslSocketQuitely();
            IOUtils.closeQuietly(this.sslInput);
            IOUtils.closeQuietly(this.sslOutput);
        }
    }

    private void closeSslSocketQuitely() {
        try {
            this.sslSocket.close();
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close sslSocket", e);
        }
        this.sslSocket = null;
    }

    private void closeQuitely() {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close socketChannel", e);
        }
        try {
            if (this.sslSocket != null) {
                this.sslSocket.close();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close sslSocket", e);
        }
        this.sslSocket = null;
    }

    @Override
    public void connect(Properties props) throws Exception {
        if (null != this.socketChannel && this.socketChannel.isConnected()) {
            return;
        }
        this.getTimeoutValue(props);
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(true);
            Socket socket = this.socketChannel.socket();
            socket.connect(this.remoteAddress, this.loginTimeout);
            this.soInput = Channels.newChannel(socket.getInputStream());
            this.configSocket(socket);
        }
        catch (Exception e) {
            if (null != this.socketChannel) {
                IOUtils.closeQuietly(this.socketChannel);
                this.socketChannel = null;
            }
            throw e;
        }
    }

    @Override
    public void negotiateSSLConnection() throws Exception {
        if (this.getUseSSL()) {
            IOClientSSL.convertSocketToSSLSocket(this);
        }
    }

    @Override
    public ByteChannel getChannel() {
        return this.socketChannel;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws SQLException {
        int onceReadSize;
        for (int readSize = byteBuffer.remaining(); readSize > 0; readSize -= onceReadSize) {
            onceReadSize = this.doReadOnce(byteBuffer, readSize);
        }
    }

    @Override
    public void write(DynamicByteBuffer byteBuffer) throws SQLException {
        ByteBuffer[] buffers = byteBuffer.getAllBuffers();
        try {
            if (this.sslSocket == null) {
                for (long msgLen = (long)byteBuffer.getDataLen(); msgLen > 0L; msgLen -= this.socketChannel.write(buffers)) {
                }
            } else {
                byte[] ba = new byte[this.configManager.getBufferSegmentSize()];
                for (ByteBuffer bb : buffers) {
                    if (bb.hasArray()) {
                        this.sslOutput.write(bb.array(), 0, bb.limit());
                        continue;
                    }
                    bb.get(ba, 0, bb.limit());
                    this.sslOutput.write(ba, 0, bb.limit());
                }
                this.sslOutput.flush();
                ba = null;
            }
        }
        catch (IOException e) {
            JDBCException ex = new JDBCException("Failed to write data to socket. ioClient:@" + Integer.toHexString(this.hashCode()) + ", reason: " + e.toString(), "08006", 304, e);
            ex.setZenithServerIp(this.getZenithUrl());
            ex.setSessionId(this.sessionId);
            throw ex;
        }
    }

    @Override
    public void write(ByteBuffer buffer) throws SQLException {
        try {
            int msgLen;
            if (this.sslSocket == null) {
                for (msgLen = buffer.limit(); msgLen > 0; msgLen -= this.socketChannel.write(buffer)) {
                }
            } else {
                byte[] bb = null;
                if (buffer.hasArray()) {
                    bb = buffer.array();
                } else {
                    bb = new byte[msgLen];
                    buffer.get(bb, 0, msgLen);
                }
                this.sslOutput.write(bb, 0, msgLen);
                this.sslOutput.flush();
            }
        }
        catch (IOException e) {
            JDBCException ex = new JDBCException("Failed to write data to socket. ioClient:@" + Integer.toHexString(this.hashCode()) + ", reason: " + e.toString(), "08006", 304, e);
            ex.setZenithServerIp(this.getZenithUrl());
            ex.setSessionId(this.sessionId);
            throw ex;
        }
    }

    private void getTimeoutValue(Properties props) throws SQLException {
        try {
            String strLoginTimeout = props.getProperty("loginTimeout");
            this.loginTimeout = strLoginTimeout == null ? this.configManager.getULoginTimeout() : Integer.parseInt(strLoginTimeout);
            this.loginTimeout *= 1000;
            String strSocketTimeout = props.getProperty("socketTimeout");
            this.socketTimeout = strSocketTimeout == null ? this.configManager.getUSocketTimeout() : Integer.parseInt(strSocketTimeout);
            this.socketTimeout *= 1000;
            String strUseSSL = props.getProperty("useSSL", "true");
            this.useSSL = Boolean.valueOf(strUseSSL);
            String strRequireSSL = props.getProperty("requireSSL", "false");
            this.requireSSL = Boolean.valueOf(strRequireSSL);
            String strVerifySrvCert = props.getProperty("verifyServerCertificate", "false");
            this.verifyServerCert = Boolean.valueOf(strVerifySrvCert);
            this.sslCiphers = props.getProperty("sslCipher");
            if (this.sslCiphers == null) {
                this.sslCiphers = this.configManager.getEnabledSSLCipherSuites();
            }
            String revocationEnabled = props.getProperty("isRevocationEnabled", "false");
            this.isRevocationEnabled = Boolean.valueOf(revocationEnabled);
        }
        catch (NumberFormatException e) {
            throw new SQLException("invalid loginTimeout/socketTimeout value, " + e.toString());
        }
    }

    private void configSocket(Socket socket) throws SocketException {
        socket.setKeepAlive(true);
        socket.setSoTimeout(this.socketTimeout);
        socket.setTcpNoDelay(this.configManager.getUSocketTCPNoDelay());
        socket.setReceiveBufferSize(this.configManager.getUSocketReceiveBufferSize());
        socket.setSendBufferSize(this.configManager.getUSocketSendBufferSize());
    }

    private int doReadOnce(ByteBuffer byteBuffer, int readSize) throws SQLException {
        try {
            int onceReadSize = 0;
            if (this.sslSocket == null) {
                onceReadSize = this.soInput.read(byteBuffer);
            } else if (byteBuffer.hasArray()) {
                int off = byteBuffer.position();
                onceReadSize = this.sslInput.read(byteBuffer.array(), off, readSize);
                if (onceReadSize > 0) {
                    byteBuffer.position(off + onceReadSize);
                }
            } else {
                byte[] bb = new byte[readSize];
                onceReadSize = this.sslInput.read(bb, 0, readSize);
                if (onceReadSize > 0) {
                    byteBuffer.put(bb, 0, onceReadSize);
                }
                bb = null;
            }
            if (onceReadSize == -1) {
                JDBCException ex = new JDBCException("Socket has been closed. ioClient:@" + Integer.toHexString(this.hashCode()), "08003", 514);
                ex.setZenithServerIp(this.getZenithUrl());
                ex.setSessionId(this.sessionId);
                throw ex;
            }
            return onceReadSize;
        }
        catch (SocketTimeoutException e) {
            JDBCException ex = new JDBCException("Socket read timeout. ioClient:@" + Integer.toHexString(this.hashCode()), "08006", 305, e);
            ex.setZenithServerIp(this.getZenithUrl());
            ex.setSessionId(this.sessionId);
            this.closeQuitely();
            throw ex;
        }
        catch (IOException e) {
            JDBCException ex = new JDBCException("Failed to read data from socket. ioClient:@" + Integer.toHexString(this.hashCode()) + ", detail: " + e.toString(), "08006", 304, e);
            ex.setZenithServerIp(this.getZenithUrl());
            ex.setSessionId(this.sessionId);
            throw ex;
        }
    }

    @Override
    public int nextSerialNumber() {
        return ++this.serialNumber;
    }

    @Override
    public int currentSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    @Override
    public void setByteOrder(ByteOrder order) {
        this.order = order;
        this.isBigEndian = ByteOrder.BIG_ENDIAN.equals(order);
    }

    @Override
    public byte getByteOrderEndian() {
        return (byte)(this.order == ByteOrder.BIG_ENDIAN ? 1 : 0);
    }

    @Override
    public String getZenithUrl() {
        if (this.ipaddr != null) {
            return this.ipaddr + ":" + this.port;
        }
        return null;
    }

    @Override
    public String getZenithIp() {
        return this.ipaddr;
    }

    @Override
    public int getZenithPort() {
        return this.port;
    }

    @Override
    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    @Override
    public int getZenithConnectionId() {
        return this.gaussConnectionId;
    }

    @Override
    public void setZenithConnectionId(int gaussConnectionId) {
        this.gaussConnectionId = gaussConnectionId;
    }

    @Override
    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    @Override
    public void setSessionSeqNo(int sessionSeqNo) {
        this.sessionSeqNo = sessionSeqNo;
    }

    @Override
    public int getSessionSeqNo() {
        return this.sessionSeqNo;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public void setLocatorSize(int locatorSize) {
        this.locatorSize = locatorSize;
    }

    @Override
    public int getLocatorSize() {
        return this.locatorSize;
    }

    @Override
    public void setCharset(int charset) {
        this.charset = charset;
    }

    @Override
    public int getCharset() {
        return this.charset;
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
    }

    @Override
    public int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    @Override
    public void setClientFlag(int flag) {
        this.clientFlag = flag;
    }

    @Override
    public int getClientFlag() {
        return this.clientFlag;
    }

    @Override
    public void setServerCapabilities(int flag) {
        this.serverCapabilities = flag;
    }

    @Override
    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public void setUseSSL(boolean flag) {
        this.useSSL = flag;
    }

    @Override
    public boolean getUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setRequireSSL(boolean flag) {
        this.requireSSL = flag;
    }

    @Override
    public boolean getRequireSSL() {
        return this.requireSSL;
    }

    @Override
    public void setVerifyServerCertificate(boolean flag) {
        this.verifyServerCert = flag;
    }

    @Override
    public boolean getVerifyServerCertificate() {
        return this.verifyServerCert;
    }

    @Override
    public void setCallVersion(int version) {
        this.callVersion = version;
    }

    @Override
    public int getCallVersion() {
        return this.callVersion;
    }

    @Override
    public void setServerVersion(int version) {
        this.serverVersion = version;
    }

    @Override
    public int getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void setEnabledSSLCipherSuites(String ciphers) {
        this.sslCiphers = ciphers;
    }

    @Override
    public String getEnabledSSLCipherSuites() {
        return this.sslCiphers;
    }

    protected void lockIOClient() {
        this.ioLock.lock();
    }

    protected void unlockIOClient() {
        this.ioLock.unlock();
    }

    @Override
    public boolean isRevocationEnabled() {
        return this.isRevocationEnabled;
    }

    @Override
    public void setRevocationEnabled(boolean isRevocationEnabled) {
        this.isRevocationEnabled = isRevocationEnabled;
    }

    @Override
    public void setServerDBTimezone(int tzValue) {
        this.severDBTimezone = tzValue;
    }

    @Override
    public Integer getServerDBTimezone() {
        return this.severDBTimezone;
    }

    @Override
    public void setClientSessionTZ(int tzValue) {
        this.clientSessionTimezone = tzValue;
    }

    @Override
    public Integer getClientSessionTZ() {
        return this.clientSessionTimezone;
    }

    @Override
    public TimeZone getDefaultJVMTimeZone() {
        if (this.defaultJVMTimeZone == null) {
            this.defaultJVMTimeZone = TimeZone.getDefault();
        }
        return this.defaultJVMTimeZone;
    }

    @Override
    public Calendar getDefaultJVMCalendar() {
        if (this.defaultJVMCalendar == null) {
            this.defaultJVMCalendar = Calendar.getInstance(this.getDefaultJVMTimeZone());
        }
        return this.defaultJVMCalendar;
    }
}

