/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.inner.IOClientImpl;
import com.huawei.gauss.om.ConfigManager;
import com.huawei.gauss.util.IOUtils;
import com.huawei.gauss.util.lang.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class IOClientSSL {
    private static final String SQL_STATE_BAD_SSL_PARAMS = "08000";

    public static void convertSocketToSSLSocket(IOClientImpl ioClient) throws SQLException {
        try {
            SSLSocketFactory sslFact = IOClientSSL.getSSLSocketFactory(ioClient);
            Socket existSocket = ioClient.getSocketChannel().socket();
            SSLSocket sslSock = (SSLSocket)sslFact.createSocket(existSocket, ioClient.getZenithIp(), ioClient.getZenithPort(), true);
            sslSock.setEnabledProtocols(new String[]{"TLSv1.2"});
            String enabledCiphers = ioClient.getEnabledSSLCipherSuites();
            if (enabledCiphers != null && enabledCiphers.length() > 0) {
                sslSock.setEnabledCipherSuites(enabledCiphers.split(":"));
            } else {
                String[] allCiphers = sslSock.getEnabledCipherSuites();
                ArrayList<String> allowedCiphers = new ArrayList<String>();
                for (String cipher : allCiphers) {
                    if (cipher.indexOf("_DHE_") > -1 && cipher.indexOf("_DH_") <= -1) continue;
                    allowedCiphers.add(cipher);
                }
                sslSock.setEnabledCipherSuites(allowedCiphers.toArray(new String[0]));
            }
            sslSock.setUseClientMode(true);
            sslSock.startHandshake();
            ioClient.sslInput = sslSock.getInputStream();
            ioClient.sslOutput = new BufferedOutputStream(sslSock.getOutputStream(), 65536);
            ioClient.sslOutput.flush();
            ioClient.sslSocket = sslSock;
        }
        catch (IOException ioe) {
            IOClientSSL.closeResources(ioClient);
            JDBCException exception = ExceptionUtil.processJDBCException(ioe.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 333, ioe);
            exception.setZenithServerIp(ioClient.getZenithUrl());
            exception.setSessionId(ioClient.getSessionId());
            throw exception;
        }
        catch (JDBCException ex) {
            IOClientSSL.closeResources(ioClient);
            ex.setZenithServerIp(ioClient.getZenithUrl());
            ex.setSessionId(ioClient.getSessionId());
            throw ex;
        }
    }

    private static void closeResources(IOClientImpl ioClient) {
        IOUtils.closeQuietly(ioClient.getSocketChannel());
        IOUtils.closeQuietly(ioClient.sslSocket);
        ioClient.sslSocket = null;
        IOUtils.closeQuietly(ioClient.sslInput);
        ioClient.sslInput = null;
        IOUtils.closeQuietly(ioClient.sslOutput);
        ioClient.sslOutput = null;
    }

    private IOClientSSL() {
    }

    private static synchronized SSLSocketFactory getSSLSocketFactory(IOClientImpl ioClient) throws SQLException {
        ConfigManager config = ioClient.getConfigManager();
        String clientKeyStoreUrl = config.getClientKeyStore();
        String clientKeyStoreType = config.getClientKeyStoreType();
        String clientKeyStorePassword = config.getClientKeyStorePassword();
        String trustKeyStoreUrl = config.getTrustKeyStore();
        String trustKeyStoreType = config.getTrustKeyStoreType();
        String trustKeyStorePassword = config.getTrustKeyStorePassword();
        if (StringUtils.isEmpty(clientKeyStoreUrl)) {
            clientKeyStoreUrl = System.getProperty("javax.net.ssl.keyStore");
            clientKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
            clientKeyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            if (!StringUtils.isEmpty(clientKeyStoreUrl)) {
                try {
                    new URL(clientKeyStoreUrl);
                }
                catch (MalformedURLException mue) {
                    clientKeyStoreUrl = "file:" + clientKeyStoreUrl;
                }
            }
        }
        if (StringUtils.isEmpty(trustKeyStoreUrl)) {
            trustKeyStoreUrl = System.getProperty("javax.net.ssl.trustStore");
            trustKeyStoreType = System.getProperty("javax.net.ssl.trustStoreType", "JKS");
            trustKeyStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            if (!StringUtils.isEmpty(trustKeyStoreUrl)) {
                try {
                    new URL(trustKeyStoreUrl);
                }
                catch (MalformedURLException mue) {
                    trustKeyStoreUrl = "file:" + trustKeyStoreUrl;
                }
            }
        }
        TrustManagerFactory tmf = null;
        KeyManagerFactory kmf = null;
        KeyManager[] kms = null;
        ArrayList<TrustManager> tms = new ArrayList<TrustManager>();
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw ExceptionUtil.processJDBCException("Default algorithm definitions for TrustManager and/or KeyManager are invalid", SQL_STATE_BAD_SSL_PARAMS, 333, nsae);
        }
        try {
            KeyStore clientKeyStore = IOClientSSL.loadKeyStore(clientKeyStoreUrl, clientKeyStoreType, clientKeyStorePassword);
            if (clientKeyStore != null) {
                char[] ca = clientKeyStorePassword == null ? new char[]{} : clientKeyStorePassword.toCharArray();
                kmf.init(clientKeyStore, ca);
                kms = kmf.getKeyManagers();
            }
        }
        catch (UnrecoverableKeyException uke) {
            throw ExceptionUtil.processJDBCException("Could not recover keys from client keystore. The password may not be empty", SQL_STATE_BAD_SSL_PARAMS, 333, uke);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw ExceptionUtil.processJDBCException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 333, nsae);
        }
        catch (KeyStoreException kse) {
            throw ExceptionUtil.processJDBCException("Could not init KeyManagerFactory using KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 333, kse);
        }
        try {
            KeyStore trustKeyStore = IOClientSSL.loadKeyStore(trustKeyStoreUrl, trustKeyStoreType, trustKeyStorePassword);
            tmf.init(trustKeyStore);
            TrustManager[] origTms = tmf.getTrustManagers();
            boolean verifyServerCert = ioClient.getVerifyServerCertificate();
            for (TrustManager tm : origTms) {
                tms.add(tm instanceof X509TrustManager ? new GaussX509TrustManager((X509TrustManager)tm, verifyServerCert, ioClient) : tm);
            }
        }
        catch (KeyStoreException kse) {
            throw ExceptionUtil.processJDBCException("Could not init TrustManagerFactory using KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 333, kse);
        }
        catch (CertificateException ce) {
            throw ExceptionUtil.processJDBCException(ce.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 333, ce);
        }
        if (tms.size() == 0) {
            tms.add(new GaussX509TrustManager());
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kms, tms.toArray(new TrustManager[tms.size()]), null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw ExceptionUtil.processJDBCException("TLS is not a valid SSL protocal", SQL_STATE_BAD_SSL_PARAMS, 333, nsae);
        }
        catch (KeyManagementException kme) {
            throw ExceptionUtil.processJDBCException("KeyManagerException: " + kme.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 333, kme);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore loadKeyStore(String keyStoreUrl, String keyStoreType, String keyStorePassword) throws SQLException {
        InputStream ksIs;
        block9: {
            KeyStore keyStore;
            ksIs = null;
            try {
                if (StringUtils.isEmpty(keyStoreUrl) || StringUtils.isEmpty(keyStoreType)) break block9;
                KeyStore keyStore2 = KeyStore.getInstance(keyStoreType);
                URL ksUrl = new URL(keyStoreUrl);
                if (ksUrl.getProtocol().equalsIgnoreCase("file")) {
                    File file = new File(keyStoreUrl.substring(5));
                    String canonicalPath = file.getCanonicalPath();
                    ksUrl = new URL("file:" + canonicalPath);
                }
                ksIs = ksUrl.openStream();
                char[] ca = keyStorePassword == null ? new char[]{} : keyStorePassword.toCharArray();
                keyStore2.load(ksIs, ca);
                keyStore = keyStore2;
            }
            catch (NoSuchAlgorithmException nsae) {
                try {
                    throw ExceptionUtil.processJDBCException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 333, nsae);
                    catch (KeyStoreException kse) {
                        throw ExceptionUtil.processJDBCException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 333, kse);
                    }
                    catch (CertificateException ce) {
                        throw ExceptionUtil.processJDBCException("Could not load client or trust " + keyStoreType + " keystore from " + keyStoreUrl, SQL_STATE_BAD_SSL_PARAMS, 333, ce);
                    }
                    catch (MalformedURLException mue) {
                        throw ExceptionUtil.processJDBCException(keyStoreUrl + " does not appear to be a valid URL", SQL_STATE_BAD_SSL_PARAMS, 333, mue);
                    }
                    catch (IOException ioe) {
                        throw ExceptionUtil.processJDBCException("Cannot open " + keyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 333, ioe);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ksIs);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(ksIs);
            return keyStore;
        }
        IOUtils.closeQuietly(ksIs);
        return null;
    }

    public static class GaussX509TrustManager
    implements X509TrustManager {
        private X509TrustManager origTm = null;
        private boolean verifyServerCert = false;
        private CertificateFactory certFactory = null;
        private PKIXParameters validatorParams = null;
        private CertPathValidator validator = null;

        public GaussX509TrustManager(X509TrustManager tm, boolean verifyServerCert, IOClientImpl ioClient) throws CertificateException {
            this.origTm = tm;
            this.verifyServerCert = verifyServerCert;
            if (verifyServerCert) {
                try {
                    HashSet<TrustAnchor> anch = new HashSet<TrustAnchor>();
                    for (X509Certificate cert : tm.getAcceptedIssuers()) {
                        anch.add(new TrustAnchor(cert, null));
                    }
                    this.validatorParams = new PKIXParameters(anch);
                    if (ioClient.isRevocationEnabled()) {
                        this.validatorParams.setRevocationEnabled(true);
                    } else {
                        this.validatorParams.setRevocationEnabled(false);
                    }
                    this.validator = CertPathValidator.getInstance("PKIX");
                    this.certFactory = CertificateFactory.getInstance("X.509");
                }
                catch (Exception e) {
                    throw new CertificateException(e);
                }
            }
        }

        public GaussX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.origTm.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509Certificate certificate : chain) {
                certificate.checkValidity();
            }
            if (this.validatorParams != null) {
                X509CertSelector certSelect = new X509CertSelector();
                certSelect.setSerialNumber(chain[0].getSerialNumber());
                try {
                    CertPath certPath = this.certFactory.generateCertPath(Arrays.asList(chain));
                    CertPathValidatorResult result = this.validator.validate(certPath, this.validatorParams);
                    ((PKIXCertPathValidatorResult)result).getTrustAnchor().getTrustedCert().checkValidity();
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CertificateException(e);
                }
                catch (CertPathValidatorException e) {
                    throw new CertificateException(e);
                }
            }
            if (this.verifyServerCert) {
                this.origTm.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.origTm != null ? this.origTm.getAcceptedIssuers() : new X509Certificate[]{};
        }
    }
}

