/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.jdbc.GaussBlob;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.GaussBlobOutputStreamImpl;
import com.huawei.gauss.jdbc.inner.GaussLobHelper;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;

public class GaussBlobImpl
extends AbstractGaussLob
implements GaussBlob {
    private byte[] binaryData = null;

    GaussBlobImpl() {
        this.setBinaryData(new byte[0]);
    }

    GaussBlobImpl(byte[] data, int length) {
        super(data, length);
        this.length = length;
        this.binaryData = new byte[length];
    }

    public void setBinaryData(byte[] newBinaryData) {
        this.binaryData = newBinaryData;
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void fetchAllDataFromServer() throws SQLException {
        this.hasFreed();
        if (this.tryFetchDataDirect(this.binaryData)) {
            return;
        }
        try {
            this.buffer.mark();
            this.buffer.position(0);
            for (int i = 0; i < this.length; ++i) {
                this.binaryData[i] = this.get();
            }
        }
        catch (RuntimeException exception) {
            IOClient ioClient = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient();
            JDBCException exeception = ExceptionUtil.processJDBCException("Fetch lob data Failed.", "42S22", 666, exception);
            exeception.setZenithServerIp(ioClient.getZenithUrl());
            exeception.setSessionId(ioClient.getSessionId());
            throw exeception;
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public long length() throws SQLException {
        this.hasFreed();
        if (this.binaryData != null) {
            return this.binaryData.length;
        }
        return 0L;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.hasFreed();
        if (pos < 1L || length < 0) {
            throw ExceptionUtil.processJDBCException("Pos is less than 1 or length is less than 0 is illegal. Pos value [" + pos + "], length value [" + length + "].");
        }
        long innerPos = pos - 1L;
        if (innerPos > (long)this.binaryData.length) {
            throw ExceptionUtil.processJDBCException("pos argument can not be larger than the BLOB's length. Pos value [" + innerPos + "].");
        }
        if (innerPos + (long)length > (long)this.binaryData.length) {
            throw ExceptionUtil.processJDBCException("[innerPos]+[length] arguments can not be larger than the BLOB's length. Pos value [" + innerPos + "].");
        }
        byte[] newData = new byte[length];
        System.arraycopy(this.getBinaryData(), (int)innerPos, newData, 0, length);
        return newData;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public InputStream getBinaryStream() throws SQLException {
        this.hasFreed();
        return new ByteArrayInputStream(this.getBinaryData());
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("position(byte[],long)");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("position(Blob,long)");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.hasFreed();
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.validatePos((int)pos);
        this.hasFreed();
        if (bytes == null) {
            return 0;
        }
        this.resetParameter();
        OutputStream bytesout = null;
        try {
            bytesout = this.setBinaryStream(pos);
            bytesout.write(bytes, offset, len);
            this.binaryData = ((ByteArrayOutputStream)bytesout).toByteArray();
        }
        catch (Exception e) {
            JDBCException exception = ExceptionUtil.processJDBCException("Save Bytes error.", "42S22", 666, e);
            throw exception;
        }
        finally {
            try {
                if (bytesout != null) {
                    bytesout.close();
                }
            }
            catch (IOException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when close binaryStream", e);
            }
        }
        return len;
    }

    @Override
    public void flushAllDataToServer() throws SQLException {
        ByteBuffer dataBuffer = ByteBuffer.wrap(this.binaryData, 0, this.binaryData.length);
        this.save(this.posIndex - 1, dataBuffer, true);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.validatePos((int)pos);
        this.hasFreed();
        this.resetParameter();
        return new GaussBlobOutputStreamImpl(this);
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("truncate(long)");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void free() throws SQLException {
        this.hasFree = true;
        this.binaryData = null;
        this.buffer = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getBinaryStream(long,long)");
    }

    @Override
    protected void fetchDataFromServer() throws SQLException {
        GaussLobHelper.fetchDataFromServer(this.gaussRes, this);
    }

    @Override
    protected void flushRestBuffer(boolean force) throws SQLException {
    }

    @Override
    public void saveDataToServer() throws SQLException {
        this.hasFreed();
        GaussLobHelper.saveDataToServer(this);
    }
}

