/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussCallableStatement;
import com.huawei.gauss.jdbc.inner.GaussBlobImpl;
import com.huawei.gauss.jdbc.inner.GaussClobImpl;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussLobHelper;
import com.huawei.gauss.jdbc.inner.GaussPrepareStatementHelper;
import com.huawei.gauss.jdbc.inner.GaussPrepareStmtImpl;
import com.huawei.gauss.jdbc.inner.TimeStampTZ;
import com.huawei.gauss.util.BytesUtil;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class GaussCallableStmtImpl
extends GaussPrepareStmtImpl
implements GaussCallableStatement {
    protected int lastReadFieldIndex = -1;

    public GaussCallableStmtImpl(GaussConnectionImpl connection, String sql) throws SQLException {
        super(connection, sql);
        this.paramsData.setNeedSetInOutType(true);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void addBatch() throws SQLException {
        this.validateOpened();
        if (this.paramsData.getCurrentParamData().hasOutParam()) {
            throw ExceptionUtil.illegalJDBCArgumentException("Stored procedure with out or inout parameters cannot be batched");
        }
        GaussPrepareStatementHelper.validateAddBatch(this);
        this.paramsData.addBatch();
        this.addBatched = true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean execute() throws SQLException {
        return super.execute();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int executeUpdate() throws SQLException {
        return super.executeUpdate();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int[] executeBatch() throws SQLException {
        return super.executeBatch();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean execute(String sql) throws SQLException {
        return super.execute(sql);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return super.execute(sql, autoGeneratedKeys);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return super.execute(sql, columnIndexes);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return super.execute(sql, columnNames);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet executeQuery(String sql) throws SQLException {
        return super.executeQuery(sql);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int executeUpdate(String sql) throws SQLException {
        return super.executeUpdate(sql);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return super.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return super.executeUpdate(sql, columnIndexes);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return super.executeUpdate(sql, columnNames);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.paramsData.setParamType(parameterIndex, sqlType);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean wasNull() throws SQLException {
        this.validateOpened();
        if (this.lastReadFieldIndex == -1) {
            throw ExceptionUtil.illegalJDBCArgumentException("has not get data");
        }
        boolean wasNull = true;
        if (this.callableParams != null) {
            wasNull = this.callableParams.wasNull(this.lastReadFieldIndex);
        }
        return wasNull;
    }

    private <V> V getValueByColumnIndex(int columnIndex, Class<V> desiredType, Object ... args) throws SQLException {
        Calendar cal = null;
        if (args.length == 0) {
            cal = null;
        } else if (args.length == 1 && args[0] instanceof Calendar) {
            cal = (Calendar)args[0];
        } else {
            throw new SQLException("invalid parameter: " + Arrays.toString(args));
        }
        V value = this.callableParams.getCallableOutValueByColumnIndex(columnIndex, desiredType, cal);
        this.lastReadFieldIndex = columnIndex;
        return value;
    }

    private void checkIndexValid(int parameterIndex) throws SQLException {
        this.validateOpened();
        if (this.callableParams == null) {
            throw ExceptionUtil.illegalJDBCArgumentException("invalid column index = " + parameterIndex);
        }
        this.callableParams.isValidIndex(parameterIndex);
    }

    private void checkNameValid(String parameterName) throws SQLException {
        this.validateOpened();
        if (this.callableParams == null) {
            throw ExceptionUtil.illegalJDBCArgumentException("invalid column index");
        }
        this.callableParams.isValidName(parameterName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getString(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        if (this.callableParams.wasNull(parameterIndex)) {
            this.lastReadFieldIndex = parameterIndex;
            return null;
        }
        String result = null;
        FieldType type = this.callableParams.getColumnType(parameterIndex);
        switch (type) {
            case CLOB: {
                byte[] bs = this.getValueByColumnIndex(parameterIndex, byte[].class, new Object[0]);
                GaussClobImpl clob = GaussLobHelper.createClob(bs, this.isBigEndianess());
                if (clob == null) break;
                clob.setResultSet(this.callableParams.getOutParamResultSet());
                result = clob.getContent();
                clob.free();
                break;
            }
            case VARBINARY: 
            case BINARY: 
            case RAW: {
                byte[] bin = this.getValueByColumnIndex(parameterIndex, byte[].class, new Object[0]);
                result = new String(bin, BytesUtil.DEFAULT_CHERSET);
                break;
            }
            case BLOB: 
            case IMAGE: {
                byte[] blobs = this.getValueByColumnIndex(parameterIndex, byte[].class, new Object[0]);
                GaussBlobImpl blob = GaussLobHelper.createBlob(blobs, this.isBigEndianess());
                if (blob == null) break;
                blob.setResultSet(this.callableParams.getOutParamResultSet());
                blob.fetchAllDataFromServer();
                result = new String(blob.getBytes(1L, (int)blob.length()), BytesUtil.DEFAULT_CHERSET);
                blob.free();
                break;
            }
            case BOOLEAN: {
                Boolean obj = this.getBoolean(parameterIndex);
                if (obj == null) break;
                result = ((Object)obj).toString();
                break;
            }
            default: {
                result = this.getValueByColumnIndex(parameterIndex, String.class, new Object[0]);
            }
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        boolean result = false;
        if (this.callableParams != null && this.getValueByColumnIndex(parameterIndex, Boolean.class, new Object[0]) != null) {
            result = this.getValueByColumnIndex(parameterIndex, Boolean.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        byte result = 0;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Byte.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public short getShort(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        short result = 0;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Short.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getInt(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        int result = 0;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Integer.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public long getLong(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        long result = 0L;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Long.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        float result = 0.0f;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Float.class, new Object[0]).floatValue();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        double result = 0.0;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Double.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkIndexValid(parameterIndex);
        BigDecimal result = null;
        if (this.callableParams != null) {
            result = this.getBigDecimal(parameterIndex);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        if (this.callableParams.wasNull(parameterIndex)) {
            this.lastReadFieldIndex = parameterIndex;
            return null;
        }
        byte[] result = null;
        FieldType type = this.callableParams.getColumnType(parameterIndex);
        switch (type) {
            case BLOB: 
            case IMAGE: {
                byte[] bs = this.getValueByColumnIndex(parameterIndex, byte[].class, new Object[0]);
                GaussBlobImpl blob = GaussLobHelper.createBlob(bs, this.isBigEndianess());
                if (blob == null) break;
                blob.setResultSet(this.callableParams.getOutParamResultSet());
                blob.fetchAllDataFromServer();
                result = blob.getBytes(1L, (int)blob.length());
                blob.free();
                break;
            }
            case VARBINARY: 
            case BINARY: 
            case RAW: {
                result = this.getValueByColumnIndex(parameterIndex, byte[].class, new Object[0]);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                result = this.getString(parameterIndex).getBytes(BytesUtil.DEFAULT_CHERSET);
                break;
            }
            default: {
                throw ExceptionUtil.notSupportedFeature(type.getJdbcTypeName() + " type can not convert to bytes value.");
            }
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        Calendar c = null;
        if (this.gaussConnection != null) {
            c = this.gaussConnection.getIOClient().getDefaultJVMCalendar();
        }
        Date result = null;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Date.class, c);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        Calendar c = null;
        if (this.gaussConnection != null) {
            c = this.gaussConnection.getIOClient().getDefaultJVMCalendar();
        }
        Time result = null;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Time.class, c);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        Calendar c = null;
        if (this.gaussConnection != null) {
            c = this.gaussConnection.getIOClient().getDefaultJVMCalendar();
        }
        Timestamp result = null;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Timestamp.class, c);
        }
        return result;
    }

    public TimeStampTZ getTimestampTZ(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        TimeStampTZ result = null;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, TimeStampTZ.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        Object result = null;
        FieldType type = this.callableParams.getColumnType(parameterIndex);
        switch (type) {
            case BOOLEAN: {
                result = this.getBoolean(parameterIndex);
                break;
            }
            case BIGINT: {
                result = this.getLong(parameterIndex);
                break;
            }
            case INTEGER: {
                result = this.getInt(parameterIndex);
                break;
            }
            case REAL: {
                result = this.getDouble(parameterIndex);
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                result = this.getBigDecimal(parameterIndex);
                break;
            }
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: {
                result = this.getTimestamp(parameterIndex);
                break;
            }
            case TIMESTAMP_TZ: {
                result = this.getTimestampTZ(parameterIndex);
                break;
            }
            case CLOB: {
                result = this.getClob(parameterIndex);
                break;
            }
            case VARBINARY: 
            case BINARY: 
            case RAW: {
                result = this.getBytes(parameterIndex);
                break;
            }
            case BLOB: 
            case IMAGE: {
                result = this.getBlob(parameterIndex);
                break;
            }
            case CURSOR: {
                long cursor = this.getLong(parameterIndex);
                if (this.wasNull()) {
                    throw new SQLException("invalid cursor, cursor is not open");
                }
                result = this.getCursor(cursor);
                break;
            }
            default: {
                result = this.getString(parameterIndex);
            }
        }
        return this.wasNull() ? null : result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        return this.getValueByColumnIndex(parameterIndex, BigDecimal.class, new Object[0]);
    }

    protected void checkLobColumn(int columnIndex) throws SQLException {
        if (!this.callableParams.checkLobType(columnIndex)) {
            StringBuilder err = new StringBuilder();
            err.append("Get column [");
            err.append(this.callableParams.getColumnName(columnIndex));
            err.append("] value failed, cause data type is [");
            err.append(this.callableParams.getColumnType(columnIndex).getName()).append("], ");
            err.append("but desired data type is Blob or Clob.");
            throw ExceptionUtil.illegalJDBCArgumentException(err.toString());
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        byte[] value = this.getValueByColumnIndex(parameterIndex, byte[].class, new Object[0]);
        if (value == null) {
            return null;
        }
        this.checkLobColumn(parameterIndex);
        GaussBlobImpl blob = GaussLobHelper.createBlob(value, this.gaussConnection.getIOClient().isBigEndian());
        if (blob != null) {
            blob.setResultSet(this.callableParams.getOutParamResultSet());
            blob.fetchAllDataFromServer();
        }
        return blob;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        byte[] value = this.getValueByColumnIndex(parameterIndex, byte[].class, new Object[0]);
        if (value == null) {
            return null;
        }
        this.checkLobColumn(parameterIndex);
        GaussClobImpl clob = GaussLobHelper.createClob(value, this.gaussConnection.getIOClient().isBigEndian());
        if (clob != null) {
            clob.setResultSet(this.callableParams.getOutParamResultSet());
            clob.getLobString();
        }
        return clob;
    }

    public int findColumn(String columnLabel) throws SQLException {
        int result = 0;
        if (this.callableParams != null) {
            result = this.callableParams.getColumnIndex(columnLabel.toUpperCase(Locale.ENGLISH));
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getString(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getString(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean getBoolean(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getBoolean(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte getByte(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getByte(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public short getShort(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getShort(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getInt(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getInt(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public long getLong(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getLong(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public float getFloat(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getFloat(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public double getDouble(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getDouble(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte[] getBytes(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getBytes(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getDate(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getTime(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getTimestamp(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Object getObject(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getObject(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getBigDecimal(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Blob getBlob(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getBlob(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Clob getClob(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getClob(this.findColumn(parameterName));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.checkIndexValid(parameterIndex);
        String data = this.getString(parameterIndex);
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Reader getCharacterStream(String parameterName) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getCharacterStream(this.findColumn(parameterName));
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkIndexValid(parameterIndex);
        Date result = null;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Date.class, cal);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkIndexValid(parameterIndex);
        Time result = null;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Time.class, cal);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkIndexValid(parameterIndex);
        Timestamp result = null;
        if (this.callableParams != null) {
            result = this.getValueByColumnIndex(parameterIndex, Timestamp.class, cal);
        }
        return result;
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getDate(this.findColumn(parameterName), cal);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getTime(this.findColumn(parameterName), cal);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.checkNameValid(parameterName);
        return this.getTimestamp(this.findColumn(parameterName), cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw ExceptionUtil.processJDBCException("don't supporrt this interface");
    }
}

