/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.connection.CloseConnectionContext;
import com.huawei.gauss.channel.context.connection.CommitContext;
import com.huawei.gauss.channel.context.connection.CreateStatementContext;
import com.huawei.gauss.channel.context.connection.DoConnectContext;
import com.huawei.gauss.channel.context.connection.PrepareCallContext;
import com.huawei.gauss.channel.context.connection.PrepareStatementContext;
import com.huawei.gauss.channel.context.connection.RollbackContext;
import com.huawei.gauss.channel.context.connection.SetAutoCommitContext;
import com.huawei.gauss.channel.context.connection.SetCatalogContext;
import com.huawei.gauss.channel.context.connection.SetClientInfoContext;
import com.huawei.gauss.channel.context.connection.SetReadOnlyContext;
import com.huawei.gauss.channel.context.connection.XAcommitContext;
import com.huawei.gauss.channel.context.connection.XAendContext;
import com.huawei.gauss.channel.context.connection.XAprepareContext;
import com.huawei.gauss.channel.context.connection.XArollbackContext;
import com.huawei.gauss.channel.context.connection.XAstartContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussPrepareStatement;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.GaussCallableStmtImpl;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussPrepareStmtImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;
import javax.transaction.xa.Xid;

public final class GaussConnectionHelper {
    private GaussConnectionHelper() {
    }

    public static void xaStart(GaussConnectionImpl connection, Xid xid, long trxTimeout, long flags) throws SQLException {
        XAstartContext context = new XAstartContext(connection.zenithDriver, connection, null);
        context.setXid(xid);
        context.setTrxTimeout(trxTimeout);
        context.setFlags(flags);
        connection.execute(context);
    }

    public static void xaEnd(GaussConnectionImpl connection, long flags) throws SQLException {
        XAendContext context = new XAendContext(connection.zenithDriver, connection, null);
        context.setFlags(flags);
        connection.execute(context);
    }

    public static int xaPrepare(GaussConnectionImpl connection, Xid xid) throws SQLException {
        XAprepareContext context = new XAprepareContext(connection.zenithDriver, connection, null);
        context.setXid(xid);
        connection.execute(context);
        return context.getRes();
    }

    public static void xaCommit(GaussConnectionImpl connection, Xid xid, long flag) throws SQLException {
        XAcommitContext context = new XAcommitContext(connection.zenithDriver, connection, null);
        context.setFlag(flag);
        context.setXid(xid);
        connection.execute(context);
    }

    public static void xaRollback(GaussConnectionImpl connection, Xid xid) throws SQLException {
        XArollbackContext context = new XArollbackContext(connection.zenithDriver, connection, null);
        context.setXid(xid);
        connection.execute(context);
    }

    static Statement createStatement(GaussConnectionImpl connection) throws SQLException {
        return GaussConnectionHelper.createStatement(connection, 1003, 1007, 2);
    }

    static Statement createStatement(GaussConnectionImpl connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        return GaussConnectionHelper.createStatement(connection, resultSetType, resultSetConcurrency, 2);
    }

    static Statement createStatement(GaussConnectionImpl connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        GaussStatementImpl statement = new GaussStatementImpl(connection);
        connection.zenithDriver.channelHandlerFactory.createStatementCHandlers(statement.channelHandlers, connection);
        CreateStatementContext statementContext = new CreateStatementContext(connection.zenithDriver, connection, statement);
        statementContext.setResultSetConfig(resultSetType, resultSetConcurrency, resultSetHoldability);
        statementContext.setResult(statement);
        connection.execute(statementContext);
        connection.gaussStatements.add((GaussStatementImpl)statementContext.getResult());
        return (Statement)statementContext.getResult();
    }

    static CallableStatement prepareCall(GaussConnectionImpl connection, String sql) throws SQLException {
        return GaussConnectionHelper.prepareCall(connection, sql, 1003, 1007, 2);
    }

    static CallableStatement prepareCall(GaussConnectionImpl connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return GaussConnectionHelper.prepareCall(connection, sql, resultSetType, resultSetConcurrency, 2);
    }

    static CallableStatement prepareCall(GaussConnectionImpl connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String escapeSQL = sql.trim();
        if (escapeSQL.startsWith("{") && escapeSQL.endsWith("}")) {
            escapeSQL = escapeSQL.substring(1, escapeSQL.length() - 1);
        }
        GaussCallableStmtImpl callableStmt = new GaussCallableStmtImpl(connection, escapeSQL);
        connection.zenithDriver.channelHandlerFactory.createPrepareStmtCHandlers(callableStmt.channelHandlers, connection);
        PrepareCallContext callContext = new PrepareCallContext(connection.zenithDriver, connection, callableStmt);
        callContext.setSql(escapeSQL);
        callContext.setResultSetConfig(resultSetType, resultSetConcurrency, resultSetHoldability);
        callContext.setResult(callableStmt);
        connection.execute(callContext);
        connection.gaussStatements.add((GaussStatementImpl)callContext.getResult());
        return (CallableStatement)callContext.getResult();
    }

    static PreparedStatement prepareStatement(GaussConnectionImpl connection, String sql) throws SQLException {
        return GaussConnectionHelper.prepareStatement(connection, sql, 2);
    }

    static PreparedStatement prepareStatement(GaussConnectionImpl connection, String sql, int autoGeneratedKeys) throws SQLException {
        GaussPrepareStmtImpl prepareStatement = new GaussPrepareStmtImpl(connection, sql);
        connection.zenithDriver.channelHandlerFactory.createPrepareStmtCHandlers(prepareStatement.channelHandlers, connection);
        PrepareStatementContext prepareStmtContext = new PrepareStatementContext(connection.zenithDriver, connection, prepareStatement);
        prepareStmtContext.setSql(sql);
        prepareStmtContext.setAutoGeneratedKeys(autoGeneratedKeys);
        return GaussConnectionHelper.prepareStatement(connection, prepareStmtContext);
    }

    static PreparedStatement prepareStatement(GaussConnectionImpl connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return GaussConnectionHelper.prepareStatement(connection, sql, resultSetType, resultSetConcurrency, 2);
    }

    static PreparedStatement prepareStatement(GaussConnectionImpl connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        GaussPrepareStmtImpl prepareStatement = new GaussPrepareStmtImpl(connection, sql);
        connection.zenithDriver.channelHandlerFactory.createPrepareStmtCHandlers(prepareStatement.channelHandlers, connection);
        PrepareStatementContext context = new PrepareStatementContext(connection.zenithDriver, connection, prepareStatement);
        context.setSql(sql);
        context.setResultSetConfig(resultSetType, resultSetConcurrency, resultSetHoldability);
        return GaussConnectionHelper.prepareStatement(connection, context);
    }

    static PreparedStatement prepareStatement(GaussConnectionImpl connection, String sql, int[] columnIndexes) throws SQLException {
        GaussPrepareStmtImpl prepareStatement = new GaussPrepareStmtImpl(connection, sql);
        connection.zenithDriver.channelHandlerFactory.createPrepareStmtCHandlers(prepareStatement.channelHandlers, connection);
        PrepareStatementContext context = new PrepareStatementContext(connection.zenithDriver, connection, prepareStatement);
        context.setSql(sql);
        context.setColumnIndexes(columnIndexes);
        return GaussConnectionHelper.prepareStatement(connection, context);
    }

    static PreparedStatement prepareStatement(GaussConnectionImpl connection, String sql, String[] columnNames) throws SQLException {
        GaussPrepareStmtImpl prepareStatement = new GaussPrepareStmtImpl(connection, sql);
        connection.zenithDriver.channelHandlerFactory.createPrepareStmtCHandlers(prepareStatement.channelHandlers, connection);
        PrepareStatementContext context = new PrepareStatementContext(connection.zenithDriver, connection, prepareStatement);
        context.setSql(sql);
        context.setColumnNames(columnNames);
        return GaussConnectionHelper.prepareStatement(connection, context);
    }

    static void rollback(GaussConnectionImpl gaussConnection) throws SQLException {
        GaussConnectionHelper.rollback(gaussConnection, null);
    }

    static void rollback(GaussConnectionImpl gaussConnection, Savepoint savepoint) throws SQLException {
        RollbackContext rollbackContext = new RollbackContext(gaussConnection.zenithDriver, gaussConnection, null);
        rollbackContext.setSavepoint(savepoint);
        gaussConnection.execute(rollbackContext);
        for (GaussStatement statment : gaussConnection.gaussStatements) {
            if (!(statment instanceof GaussPrepareStmtImpl) && !(statment instanceof GaussCallableStmtImpl)) continue;
            statment.clearBatch();
        }
    }

    static void setAutoCommit(GaussConnectionImpl gaussConnection, boolean autoCommit) throws SQLException {
        SetAutoCommitContext setAutoCommitContext = new SetAutoCommitContext(gaussConnection.zenithDriver, gaussConnection, null);
        setAutoCommitContext.setAutoCommit(autoCommit);
        gaussConnection.execute(setAutoCommitContext);
    }

    static void setCatalog(GaussConnectionImpl gaussConnection, String catalog) throws SQLException {
        SetCatalogContext setCatalogContext = new SetCatalogContext(gaussConnection.zenithDriver, gaussConnection, null);
        setCatalogContext.setCatalog(catalog);
        gaussConnection.execute(setCatalogContext);
    }

    static void setClientInfo(GaussConnectionImpl gaussConnection, Properties properties, String name, String value) {
        SetClientInfoContext setClientInfoContext = new SetClientInfoContext(gaussConnection.zenithDriver, gaussConnection, null);
        setClientInfoContext.setProperties(properties);
        setClientInfoContext.setProperty(name, value);
        try {
            gaussConnection.execute(setClientInfoContext);
        }
        catch (SQLException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when set client info", e);
        }
    }

    static void setReadOnly(GaussConnectionImpl gaussConnection, boolean readOnly) throws SQLException {
        SetReadOnlyContext setReadOnlyContext = new SetReadOnlyContext(gaussConnection.zenithDriver, gaussConnection, null);
        setReadOnlyContext.setReadOnly(readOnly);
        gaussConnection.execute(setReadOnlyContext);
    }

    private static GaussPrepareStatement prepareStatement(GaussConnectionImpl connection, PrepareStatementContext context) throws SQLException {
        connection.execute(context);
        GaussPrepareStatement prepareStmt = (GaussPrepareStatement)context.getResult();
        connection.gaussStatements.add(prepareStmt);
        ((GaussPrepareStmtImpl)prepareStmt).setGeneratedKeyType(context.getAutoGeneratedKeys());
        return prepareStmt;
    }

    static void close(GaussConnectionImpl connection) throws SQLException {
        CloseConnectionContext context = new CloseConnectionContext(connection.zenithDriver, connection, null);
        connection.execute(context);
    }

    static void commit(GaussConnectionImpl connection) throws SQLException {
        CommitContext context = new CommitContext(connection.zenithDriver, connection, null);
        connection.execute(context);
    }

    static void connect(GaussConnectionImpl connection) throws SQLException {
        DoConnectContext context = new DoConnectContext(connection.zenithDriver, connection, null);
        connection.execute(context);
    }
}

