/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.GaussResultSetHelper;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import java.sql.SQLException;

public class GaussCursorResultSetImpl
extends GaussResultSetImpl {
    public static final int FETCH_MODE_NORMAL = 0;
    public static final int FETCH_MODE_PREP_EXEC = 1;
    public static final int FETCH_MODE_PREP_FETCH = 2;
    private boolean firstPackage = true;
    private int fetchMode = 0;

    public GaussCursorResultSetImpl(GaussStatement gaussStatement, String sql, int fetchMode) {
        super(gaussStatement, sql);
        this.fetchMode = fetchMode;
    }

    public void fetchFirstPackage() throws SQLException {
        if (this.firstPackage) {
            this.rowsData = GaussResultSetHelper.fetchCursorRows(this.gaussStatement, this);
            this.firstPackage = false;
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNext = this.rowsData.next();
        if (!hasNext && this.rowsData.hasMoreRows()) {
            this.rowsData = GaussResultSetHelper.fetchCursorRows(this.gaussStatement, this);
            hasNext = this.rowsData.next();
        }
        if (hasNext) {
            this.gaussStatement.incCurrRowSize();
        }
        return hasNext;
    }

    @Override
    public void close() throws SQLException {
        if (this.rowsData == null) {
            return;
        }
        try {
            if (this.rowsData != null && this.rowsData.needClear()) {
                GaussResultSetHelper.close(this, this.gaussStatement);
            }
        }
        finally {
            this.rowsData = null;
        }
        try {
            this.gaussStatement.close();
        }
        catch (SQLException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close statement", e);
        }
    }

    public boolean isFirstPackage() {
        return this.firstPackage;
    }

    public void setFirstPackage(boolean firstPackage) {
        this.firstPackage = firstPackage;
    }

    public int getFetchMode() {
        return this.fetchMode;
    }

    public void setFetchMode(int fetchMode) {
        this.fetchMode = fetchMode;
    }
}

