/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.cluster.api.GaussClusterNode;
import com.huawei.gauss.cluster.check.CheckConnectionPool;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussSubDriverAbstract;
import com.huawei.gauss.util.BytesUtil;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Properties;

public class GaussInfoImpl
implements GaussInfo {
    private Charset charset = BytesUtil.DEFAULT_CHERSET;
    protected String nodeIp;
    protected String nodePort;
    protected String ipAndPort;
    protected String user;
    protected String originalUrl;
    protected boolean isCluster = false;

    public GaussInfoImpl() {
    }

    public GaussInfoImpl(String url) throws SQLException {
        this.initBaseInfo(this.parseUrl(url));
    }

    public synchronized void initBaseInfo(String[] ipPorts) {
        this.setNodeIp(ipPorts[0]);
        this.setNodePort(ipPorts[1]);
        this.setIpAndPort(ipPorts[0] + ":" + ipPorts[1]);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getOriginalUrl() {
        return this.originalUrl;
    }

    @Override
    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    @Override
    public String getNodeIp() {
        return this.nodeIp;
    }

    @Override
    public void setNodeIp(String nodeIp) {
        this.nodeIp = nodeIp;
    }

    @Override
    public String getNodePort() {
        return this.nodePort;
    }

    @Override
    public void setNodePort(String nodePort) {
        this.nodePort = nodePort;
    }

    @Override
    public String getIpAndPort() {
        return this.ipAndPort;
    }

    @Override
    public void setIpAndPort(String ipAndPort) {
        this.ipAndPort = ipAndPort;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void initConnInfoFrom(GaussInfo gsInfo) {
        this.setNodeIp(gsInfo.getNodeIp());
        this.setNodePort(gsInfo.getNodePort());
        this.setIpAndPort(gsInfo.getIpAndPort());
        this.isCluster = gsInfo instanceof GaussClusterNode;
    }

    @Override
    public boolean isCluster() {
        return this.isCluster;
    }

    @Override
    public void setCluster() {
        this.isCluster = true;
    }

    @Override
    public GaussConnectionImpl createConnection(GaussSubDriverAbstract driver, Properties props) throws SQLException {
        SocketAddress gaussAddress = driver.getSocketAddress(this.getNodeIp(), this.getNodePort());
        GaussConnectionImpl connection = driver.constructConnection(gaussAddress, props);
        CheckConnectionPool.registeGaussNodeConnInfo(connection.ioClient.getZenithUrl(), props.getProperty("user"), props.getProperty("password"));
        GaussInfo gaussInfo = connection.getZenithInfo();
        gaussInfo.initConnInfoFrom(this);
        return connection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GaussNodeInfo:{");
        sb.append("isCluster=[").append(this.isCluster);
        sb.append("], ipAndPort=[").append(this.ipAndPort);
        sb.append("], charset=[").append(this.charset);
        sb.append("], userName=[").append(this.user);
        sb.append("]}");
        return sb.toString();
    }
}

