/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.FetchLobDataContext;
import com.huawei.gauss.channel.context.statement.prepare.SaveLobDataContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussResultSet;
import com.huawei.gauss.jdbc.IGaussDriver;
import com.huawei.gauss.jdbc.inner.GaussBlobImpl;
import com.huawei.gauss.jdbc.inner.GaussClobImpl;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussDriver;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import com.huawei.gauss.util.BytesUtil;
import java.sql.SQLException;
import java.util.Arrays;

public class GaussLobHelper {
    private GaussLobHelper() {
    }

    public static GaussBlobImpl createBlob(byte[] data, boolean isBigEndianess) throws SQLException {
        AbstractGaussLob gaussLob = GaussLobHelper.createAbstractGaussLob(true, data, isBigEndianess);
        return gaussLob == null ? null : (GaussBlobImpl)gaussLob;
    }

    public static GaussClobImpl createClob(byte[] data, boolean isBigEndianess) throws SQLException {
        AbstractGaussLob gaussLob = GaussLobHelper.createAbstractGaussLob(false, data, isBigEndianess);
        return gaussLob == null ? null : (GaussClobImpl)gaussLob;
    }

    private static AbstractGaussLob createAbstractGaussLob(boolean isBlob, byte[] data, boolean isBigEndianess) throws SQLException {
        if (data == null || data.length == 0) {
            return null;
        }
        AbstractGaussLob blob = null;
        try {
            int totalSize = BytesUtil.toInt(data, 0, isBigEndianess);
            byte[] handler = Arrays.copyOfRange(data, 0, data.length);
            blob = isBlob ? new GaussBlobImpl(handler, totalSize) : new GaussClobImpl(handler, totalSize);
        }
        catch (RuntimeException exception) {
            throw ExceptionUtil.illegalJDBCArgumentException("Failed to create lob object.", exception);
        }
        return blob;
    }

    public static void fetchDataFromServer(GaussResultSet gaussResultSet, AbstractGaussLob gaussLob) throws SQLException {
        GaussResultSetImpl gaussResultSetImpl = (GaussResultSetImpl)gaussResultSet;
        GaussDriver gaussDriver = gaussResultSetImpl.gaussStatement.gaussDriver;
        GaussConnectionImpl gaussConnection = gaussResultSetImpl.gaussStatement.gaussConnection;
        FetchLobDataContext context = new FetchLobDataContext((IGaussDriver)gaussDriver, (GaussConnection)gaussConnection, gaussLob);
        gaussResultSetImpl.execute(context);
    }

    public static void saveDataToServer(AbstractGaussLob gaussLob) throws SQLException {
        GaussStatementImpl gaussStatement = (GaussStatementImpl)gaussLob.getStatement();
        SaveLobDataContext context = new SaveLobDataContext((IGaussDriver)gaussStatement.gaussDriver, (GaussConnection)gaussStatement.gaussConnection, gaussLob);
        gaussStatement.execute(context);
    }
}

