/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussTypeToJava;
import com.huawei.gauss.util.BytesUtil;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class GaussOfflineResultSet
extends GaussResultSetImpl {
    private boolean isForColumns = false;

    public GaussOfflineResultSet(GaussResultSetImpl gaussResultSetImpl) throws SQLException {
        super(null, null);
        this.isOfflineResult = true;
        this.fetchAllData(gaussResultSetImpl);
    }

    public GaussOfflineResultSet(GaussResultSetImpl gaussResultSetImpl, boolean isForColumns) throws SQLException {
        super(null, null);
        this.isOfflineResult = true;
        this.isForColumns = true;
        this.fetchAllData(gaussResultSetImpl);
    }

    protected final void fetchAllData(GaussResultSetImpl gaussResultSet) throws SQLException {
        ArrayList<RowsData.RowData> allRowDatas = new ArrayList<RowsData.RowData>();
        while (gaussResultSet.next()) {
            if (this.isForColumns) {
                RowsData.FieldDef[] fieldDefs = gaussResultSet.rowsData.getFieldDefs();
                FieldType fieldType = fieldDefs[4].getFieldType();
                RowsData.RowData rowData = gaussResultSet.rowsData.getCurrentRowData();
                String dataTypeValue = rowData.getValue(4, fieldType, String.class, gaussResultSet.rowsData.isBigEndianess(), null, null);
                Integer javaType = GaussTypeToJava.getGaussToJdbcType().get(dataTypeValue);
                if (javaType == null) {
                    javaType = 1111;
                }
                RowsData.FieldValue fieldValue = new RowsData.FieldValue(4, BytesUtil.getBytes(javaType, gaussResultSet.rowsData.isBigEndianess()));
                rowData.setValue(4, fieldValue);
                allRowDatas.add(rowData);
                continue;
            }
            allRowDatas.add(gaussResultSet.rowsData.getCurrentRowData());
        }
        RowsData.RowData[] allDatas = new RowsData.RowData[allRowDatas.size()];
        allDatas = allRowDatas.toArray(allDatas);
        if (this.isForColumns) {
            RowsData.FieldDef[] fieldDefs = gaussResultSet.rowsData.getFieldDefs();
            fieldDefs[4].setFieldType(FieldType.INTEGER);
        }
        this.rowsData = new RowsData(gaussResultSet.rowsData.getFieldDefs(), allDatas, 0, gaussResultSet.gaussStatement.isBigEndianess() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN, gaussResultSet.gaussStatement.gaussConnection);
        this.rowsData.beforeFirst();
    }

    @Override
    public void close() throws SQLException {
        this.rowsData = null;
        this.isOfflineResult = false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowsData == null) {
            throw new SQLException("ResultSet operation not allowed after ResultSet closed.");
        }
        return this.rowsData.next();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rowsData == null;
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Offlline resultSet has not bind the statement.");
    }
}

