/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussResultSet;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.ChannelExecutor;
import com.huawei.gauss.jdbc.inner.GaussBlobImpl;
import com.huawei.gauss.jdbc.inner.GaussClobImpl;
import com.huawei.gauss.jdbc.inner.GaussLobHelper;
import com.huawei.gauss.jdbc.inner.GaussOfflineResultSet;
import com.huawei.gauss.jdbc.inner.GaussResultSetHelper;
import com.huawei.gauss.jdbc.inner.GaussResultSetMetaDataImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import com.huawei.gauss.jdbc.inner.TimeStampTZ;
import com.huawei.gauss.util.BytesUtil;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;

public class GaussResultSetImpl
extends ChannelExecutor
implements GaussResultSet {
    protected GaussStatementImpl gaussStatement;
    protected RowsData rowsData;
    protected int fetchRows;
    protected String sql;
    protected int lastReadFieldIndex = -1;
    protected boolean isOfflineResult = false;
    SQLWarning sqlWarning;

    public GaussResultSetImpl(GaussStatement gaussStatement, String sql) {
        this.gaussStatement = (GaussStatementImpl)gaussStatement;
        this.sql = sql;
    }

    private void checkStatementLangType() throws SQLException {
        GaussStatement gaussStatement = (GaussStatement)this.getStatement();
        if (gaussStatement.getLangType() == 4) {
            throw ExceptionUtil.illegalJDBCArgumentException("can't retrieve data for PLSQL statement by using next");
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean next() throws SQLException {
        this.isClosedResult();
        this.checkStatementLangType();
        boolean hasNext = false;
        if (!this.gaussStatement.isReachMaxSize() && this.rowsData != null) {
            hasNext = this.rowsData.next();
            if (!hasNext && this.rowsData.hasMoreRows()) {
                this.rowsData = GaussResultSetHelper.fetchMoreRows(this.gaussStatement, this, this.rowsData);
                hasNext = this.rowsData.next();
            }
            if (hasNext) {
                this.gaussStatement.incCurrRowSize();
            }
        }
        return hasNext;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.rowsData != null && this.rowsData.needClear()) {
                GaussResultSetHelper.close(this, this.gaussStatement);
            }
        }
        finally {
            this.gaussStatement = null;
            this.rowsData = null;
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean wasNull() throws SQLException {
        this.isClosedResult();
        if (this.lastReadFieldIndex == -1) {
            throw ExceptionUtil.illegalJDBCArgumentException("has not get data");
        }
        boolean wasNull = true;
        if (this.rowsData != null) {
            wasNull = this.rowsData.wasNull(this.lastReadFieldIndex);
        }
        return wasNull;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getString(int columnIndex) throws SQLException {
        this.isClosedResult();
        if (this.rowsData.wasNull(columnIndex)) {
            this.lastReadFieldIndex = columnIndex;
            return null;
        }
        String result = null;
        FieldType type = this.rowsData.getColumnType(columnIndex);
        switch (type) {
            case CLOB: {
                byte[] bs = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
                GaussClobImpl clob = GaussLobHelper.createClob(bs, this.gaussStatement.isBigEndianess());
                if (clob == null) break;
                clob.setResultSet(this);
                result = clob.getContent();
                clob.free();
                break;
            }
            case BINARY: 
            case VARBINARY: {
                byte[] bin = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
                result = new String(bin, BytesUtil.DEFAULT_CHERSET);
                break;
            }
            case RAW: {
                byte[] bin = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
                result = BytesUtil.rawToHex(bin);
                break;
            }
            case BLOB: 
            case IMAGE: {
                byte[] blobs = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
                GaussBlobImpl blob = GaussLobHelper.createBlob(blobs, this.gaussStatement.isBigEndianess());
                if (blob == null) break;
                blob.setResultSet(this);
                blob.fetchAllDataFromServer();
                result = new String(blob.getBytes(1L, (int)blob.length()), BytesUtil.DEFAULT_CHERSET);
                blob.free();
                break;
            }
            case BOOLEAN: {
                Boolean obj = this.getBoolean(columnIndex);
                if (obj == null) break;
                result = ((Object)obj).toString();
                break;
            }
            default: {
                result = this.getValueByColumnIndex(columnIndex, String.class, new Object[0]);
            }
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean temp;
        this.isClosedResult();
        boolean result = false;
        if (this.rowsData != null && (temp = this.getValueByColumnIndex(columnIndex, Boolean.class, new Object[0])) != null) {
            result = temp;
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte getByte(int columnIndex) throws SQLException {
        this.isClosedResult();
        byte result = 0;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Byte.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public short getShort(int columnIndex) throws SQLException {
        this.isClosedResult();
        short result = 0;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Short.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getInt(int columnIndex) throws SQLException {
        this.isClosedResult();
        int result = 0;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Integer.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public long getLong(int columnIndex) throws SQLException {
        this.isClosedResult();
        long result = 0L;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Long.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public float getFloat(int columnIndex) throws SQLException {
        this.isClosedResult();
        float result = 0.0f;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Float.class, new Object[0]).floatValue();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public double getDouble(int columnIndex) throws SQLException {
        this.isClosedResult();
        double result = 0.0;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Double.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.isClosedResult();
        BigDecimal result = null;
        if (this.rowsData != null) {
            result = this.getBigDecimal(columnIndex);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.isClosedResult();
        if (this.rowsData.wasNull(columnIndex)) {
            this.lastReadFieldIndex = columnIndex;
            return null;
        }
        byte[] result = null;
        FieldType type = this.rowsData.getColumnType(columnIndex);
        switch (type) {
            case BLOB: 
            case IMAGE: {
                byte[] bs = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
                GaussBlobImpl blob = GaussLobHelper.createBlob(bs, this.gaussStatement.isBigEndianess());
                if (blob == null) break;
                blob.setResultSet(this);
                blob.fetchAllDataFromServer();
                result = blob.getBytes(1L, (int)blob.length());
                blob.free();
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case RAW: {
                result = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                result = this.getString(columnIndex).getBytes(BytesUtil.DEFAULT_CHERSET);
                break;
            }
            default: {
                throw ExceptionUtil.notSupportedFeature(type.getJdbcTypeName() + " type can not convert to bytes value.");
            }
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(int columnIndex) throws SQLException {
        this.isClosedResult();
        Calendar c = null;
        if (this.gaussStatement != null) {
            c = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient().getDefaultJVMCalendar();
        }
        Date result = null;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Date.class, c);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(int columnIndex) throws SQLException {
        this.isClosedResult();
        Calendar c = null;
        if (this.gaussStatement != null) {
            c = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient().getDefaultJVMCalendar();
        }
        Time result = null;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Time.class, c);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.isClosedResult();
        Calendar c = null;
        if (this.gaussStatement != null) {
            c = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient().getDefaultJVMCalendar();
        }
        Timestamp result = null;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Timestamp.class, c);
        }
        return result;
    }

    private TimeStampTZ getTimestampTZ(int columnIndex) throws SQLException {
        this.isClosedResult();
        TimeStampTZ result = null;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, TimeStampTZ.class, new Object[0]);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.isClosedResult();
        byte[] data = this.getBytes(columnIndex);
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getString(String columnLabel) throws SQLException {
        int index = this.findColumn(columnLabel);
        return this.getString(index);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public void setSqlWarning(SQLWarning sqlWarning) {
        this.sqlWarning = sqlWarning;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public GaussResultSetMetaDataImpl getMetaData() throws SQLException {
        this.isClosedResult();
        return new GaussResultSetMetaDataImpl(this.rowsData.fieldDefs);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Object getObject(int columnIndex) throws SQLException {
        this.isClosedResult();
        Object result = null;
        FieldType type = this.rowsData.getColumnType(columnIndex);
        switch (type) {
            case BOOLEAN: {
                result = this.getBoolean(columnIndex);
                break;
            }
            case BIGINT: {
                result = this.getLong(columnIndex);
                break;
            }
            case INTEGER: {
                result = this.getInt(columnIndex);
                break;
            }
            case REAL: {
                result = this.getDouble(columnIndex);
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                result = this.getBigDecimal(columnIndex);
                break;
            }
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: {
                result = this.getTimestamp(columnIndex);
                break;
            }
            case TIMESTAMP_TZ: {
                result = this.getTimestampTZ(columnIndex);
                break;
            }
            case CLOB: {
                result = this.getClob(columnIndex);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                result = this.getBytes(columnIndex);
                break;
            }
            case BLOB: 
            case IMAGE: {
                result = this.getBlob(columnIndex);
                break;
            }
            default: {
                result = this.getString(columnIndex);
            }
        }
        return this.wasNull() ? null : result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int findColumn(String columnLabel) throws SQLException {
        int result = 0;
        if (this.rowsData != null) {
            result = this.rowsData.getFieldIndex(columnLabel);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.isClosedResult();
        String data = this.getString(columnIndex);
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.isClosedResult();
        return this.getValueByColumnIndex(columnIndex, BigDecimal.class, new Object[0]);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Blob getBlob(int columnIndex) throws SQLException {
        this.isClosedResult();
        byte[] value = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
        if (value == null) {
            return null;
        }
        this.checkLobColumn(columnIndex);
        GaussBlobImpl blob = GaussLobHelper.createBlob(value, this.rowsData.isBigEndianess());
        if (blob != null) {
            blob.setResultSet(this);
            blob.fetchAllDataFromServer();
        }
        return blob;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Clob getClob(int columnIndex) throws SQLException {
        this.isClosedResult();
        byte[] value = this.getValueByColumnIndex(columnIndex, byte[].class, new Object[0]);
        if (value == null) {
            return null;
        }
        this.checkLobColumn(columnIndex);
        GaussClobImpl clob = GaussLobHelper.createClob(value, this.rowsData.isBigEndianess());
        if (clob != null) {
            clob.setResultSet(this);
            clob.getLobString();
        }
        return clob;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isBeforeFirst() throws SQLException {
        this.isClosedResult();
        boolean result = false;
        if (this.rowsData != null) {
            result = this.rowsData.isBeforeFirst();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isAfterLast() throws SQLException {
        this.isClosedResult();
        boolean result = false;
        if (this.rowsData != null) {
            result = this.rowsData.isAfterLast();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isFirst() throws SQLException {
        this.isClosedResult();
        boolean result = false;
        if (this.rowsData != null) {
            result = this.rowsData.isFirst();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isLast() throws SQLException {
        this.isClosedResult();
        boolean result = false;
        if (this.rowsData != null) {
            result = this.rowsData.isLast();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void beforeFirst() throws SQLException {
        this.isClosedResult();
        if (this.rowsData != null) {
            this.rowsData.beforeFirst();
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void afterLast() throws SQLException {
        this.isClosedResult();
        if (this.rowsData != null) {
            this.rowsData.afterLast();
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getRow() throws SQLException {
        this.isClosedResult();
        int result = 0;
        if (this.rowsData != null) {
            result = this.rowsData.getRow();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean absolute(int row) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean relative(int rows) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw ExceptionUtil.processJDBCException("Fetch direction only support ResultSet.FETCH_FORWARD.", "0A000", 513);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw ExceptionUtil.illegalJDBCArgumentException("Fetch rows >= 0 is not satisfied, rows is [" + rows + "].");
        }
        this.fetchRows = rows;
    }

    public int getFetchRows() {
        return this.fetchRows;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getFetchSize() throws SQLException {
        this.isClosedResult();
        int result = 0;
        if (this.rowsData != null) {
            result = this.rowsData.getRowCount();
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isClosed() throws SQLException {
        return this.gaussStatement == null || this.rowsData == null;
    }

    private void isClosedResult() throws SQLException {
        if (!(this.isOfflineResult || this.gaussStatement != null && this.rowsData != null)) {
            throw new SQLException("ResultSet operation not allowed after ResultSet closed.");
        }
    }

    @Override
    public void setRowsData(RowsData rowsData) {
        this.rowsData = rowsData;
        this.rowsData.setSql(this.sql);
    }

    public RowsData getRowsData() {
        return this.rowsData;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Statement getStatement() throws SQLException {
        return this.gaussStatement;
    }

    public int getColumnCount() {
        if (this.rowsData != null) {
            return this.rowsData.getColumnCount();
        }
        return 0;
    }

    public boolean getIsNotNull(int columnIndex) throws SQLException {
        if (this.rowsData != null) {
            return this.rowsData.getIsNotNull(columnIndex);
        }
        return false;
    }

    public int getColumnWidth(int columnIndex) throws SQLException {
        if (this.rowsData != null) {
            return this.rowsData.getColumnWidth(columnIndex);
        }
        return 0;
    }

    public String getColumnName(int columnIndex) throws SQLException {
        if (this.rowsData != null) {
            return this.rowsData.getColumnName(columnIndex);
        }
        return null;
    }

    public int getPrecision(int columnIndex) throws SQLException {
        if (this.rowsData != null) {
            return this.rowsData.getPrecision(columnIndex);
        }
        return 0;
    }

    public int getScale(int columnIndex) throws SQLException {
        if (this.rowsData != null) {
            return this.rowsData.getScale(columnIndex);
        }
        return 0;
    }

    public int getColumnType(int columnIndex) throws SQLException {
        if (this.rowsData != null) {
            return this.rowsData.getColumnType(columnIndex).getJdbcType();
        }
        return 0;
    }

    public String getColumnTypeName(int columnIndex) throws SQLException {
        if (this.rowsData != null) {
            return this.rowsData.getColumnType(columnIndex).getName();
        }
        return "UNKNOWN";
    }

    private <V> V getValueByColumnIndex(int columnIndex, Class<V> desiredType, Object ... args) throws SQLException {
        this.isValidIndexColumn(columnIndex, this.rowsData);
        Calendar cal = null;
        if (args.length == 0) {
            cal = null;
        } else {
            if (args.length != 1 || !(args[0] instanceof Calendar)) {
                throw new SQLException("invalid parameter: " + Arrays.toString(args));
            }
            cal = (Calendar)args[0];
        }
        V value = this.rowsData.getValue(columnIndex, desiredType, cal);
        this.lastReadFieldIndex = columnIndex;
        return value;
    }

    protected GaussOfflineResultSet offlineResultSet() throws SQLException {
        return new GaussOfflineResultSet(this);
    }

    protected GaussOfflineResultSet offlineResultSetForGetColumns() throws SQLException {
        return new GaussOfflineResultSet(this, true);
    }

    protected void checkLobColumn(int columnIndex) throws SQLException {
        if (!this.rowsData.checkLobType(columnIndex)) {
            StringBuilder err = new StringBuilder();
            err.append("Get column [");
            err.append(this.getColumnName(columnIndex));
            err.append("] value failed, cause data type is [");
            err.append(this.getColumnTypeName(columnIndex)).append("], ");
            err.append("but desired data type is Blob or Clob.");
            throw ExceptionUtil.illegalJDBCArgumentException(err.toString());
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getAsciiStream(int)");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getUnicodeStream(int)");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getAsciiStream(String)");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getUnicodeStream(String)");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("rowDeleted");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateObject");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNull");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateCharacterStream");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("moveToCurrentRow");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getObject(int,Map<String, Class<?>>)");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getRef(int)");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getArray(int)");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getObject(String,Map<String, Class<?>>)");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getRef(String)");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getArray(String)");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date result = null;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Date.class, cal);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time result = null;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Time.class, cal);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp result = null;
        if (this.rowsData != null) {
            result = this.getValueByColumnIndex(columnIndex, Timestamp.class, cal);
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getURL(int)");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getURL(String)");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateRef(int,Ref)");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateRef(String,Ref)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBlob(int,Blob)");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBlob(String,Blob)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateClob(int,Clob)");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateClob(String,Clob)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateArray(int,Array)");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateArray(String,Array)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getRowId(int)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getRowId(String)");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateRowId(int,RowId)");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateRowId(String,RowId)");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNString(int,String)");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNString(String,String)");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNClob(int,NClob)");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNClob(String,NClob)");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getNClob(int)");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getNClob(String)");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getSQLXML(int)");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getSQLXML(String)");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateSQLXML(int)");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateSQLXML(String,SQLXML)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getNString(int)");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getNString(String)");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getNCharacterStream(String)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNCharacterStream(int,Reader,long)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNCharacterStream(String,Reader,long)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateAsciiStream(int,InputStream,long)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBinaryStream(int,InputStream,long)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateCharacterStream(int,Reader,long)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateAsciiStream(String,InputStream,long)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBinaryStream(String,InputStream,long)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateCharacterStream(String,Reader,long)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBlob(int,InputStream,long)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBlob(String,InputStream,long)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateClob(int,Reader,long)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateClob(String,Reader,long)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNClob(int,Reader,long)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNClob(String,Reader,long)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNCharacterStream(int,Reader)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNCharacterStream(String,Reader)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateAsciiStream(int,InputStream)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBinaryStream(int,InputStream)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateCharacterStream(int,Reader)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateAsciiStream(String,InputStream)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBinaryStream(String,InputStream)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateCharacterStream(String,Reader)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBlob(int,InputStream)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateBlob(String,InputStream)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateClob(int,Reader)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateClob(String,Reader)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNClob(int,Reader)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("updateNClob(String,Reader)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("unwrap(String,Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("isWrapperFor(Class<?>)");
    }

    private void isValidIndexColumn(int columnIndex, RowsData rowDatas) throws SQLException {
        if (columnIndex <= 0) {
            throw ExceptionUtil.illegalJDBCArgumentException("Column index must larger than 0!");
        }
        if (columnIndex > rowDatas.getColumnCount()) {
            throw ExceptionUtil.illegalJDBCArgumentException("ResultSet Column Index out of range high!");
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("isWrapperFor(Class<?>)");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("isWrapperFor(Class<?>)");
    }
}

