/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussResultSetMetaData;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.sql.SQLException;

public class GaussResultSetMetaDataImpl
implements GaussResultSetMetaData {
    final RowsData.FieldDef[] fieldDefs;

    public GaussResultSetMetaDataImpl(RowsData.FieldDef[] fieldDefs) {
        this.fieldDefs = fieldDefs;
    }

    private void validColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.fieldDefs.length) {
            throw ExceptionUtil.processJDBCException("Index " + column + " should start from 1 and less than " + this.fieldDefs.length + ".", "S1002", 635);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getColumnCount() throws SQLException {
        return this.fieldDefs.length;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public int isNullable(int column) throws SQLException {
        this.validColumnIndex(column);
        if (this.fieldDefs[column - 1].isNotNull()) {
            return 0;
        }
        return 1;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getColumnDisplaySize(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.fieldDefs[column - 1].getColumnWidth();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getColumnLabel(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.getColumnName(column);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getColumnName(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.fieldDefs[column - 1].getColumnName();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getPrecision(int column) throws SQLException {
        this.validColumnIndex(column);
        RowsData.FieldDef fieldDef = this.fieldDefs[column - 1];
        switch (fieldDef.getFieldType()) {
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case BINARY: 
            case VARBINARY: {
                return fieldDef.getColumnWidth();
            }
            case CLOB: 
            case BLOB: 
            case IMAGE: {
                return -1;
            }
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_TZ: {
                return 0;
            }
        }
        return fieldDef.getPrecision();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getScale(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.fieldDefs[column - 1].getScale();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getColumnType(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.fieldDefs[column - 1].getFieldType().getJdbcType();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getColumnTypeName(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.fieldDefs[column - 1].getFieldType().getName();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getColumnClassName(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.fieldDefs[column - 1].getFieldType().getJdbcTypeName();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isAutoIncrement(int column) throws SQLException {
        this.validColumnIndex(column);
        return this.fieldDefs[column - 1].isAutoIncrement();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }
}

