/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.CallableParams;
import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.ChannelExecutor;
import com.huawei.gauss.jdbc.inner.GaussConnectionHelper;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussCursorResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussDriver;
import com.huawei.gauss.jdbc.inner.GaussParamDef;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementHelper;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class GaussStatementImpl
extends ChannelExecutor
implements GaussStatement {
    protected int statementId = -1;
    protected GaussResultSetImpl resultSet;
    protected GaussResultSetImpl generatedKeys;
    protected CallableParams callableParams;
    protected List<Long> multiResultSets = new LinkedList<Long>();
    protected List<ResultSet> returnResults = new LinkedList<ResultSet>();
    protected int currentResultIndex = 0;
    protected int updateCount;
    protected int sqlType;
    protected int langType;
    protected int[] affectedRows;
    protected SQLWarning sqlWarning;
    protected int userQueryTimeout;
    protected boolean isPoolable;
    protected boolean escapeProcess;
    protected int fetchSize;
    protected int maxRowSize;
    protected int currRowSize;
    protected int maxFieldSize = 0;
    protected RowsData.FieldDef[] fieldDefs;
    protected GaussParamDef[] paramDefs;
    boolean hasExecuted;
    final GaussDriver gaussDriver;
    GaussConnectionImpl gaussConnection;
    private Long stmtUUID;
    private Properties stmtProperties;

    public GaussStatementImpl(GaussConnectionImpl connection) throws SQLException {
        this.gaussDriver = connection.zenithDriver;
        this.gaussConnection = connection;
        this.stmtProperties = connection.getStmtProperties();
    }

    @Override
    public void setGeneratedKeyRows(GaussResultSetImpl generatedKey) {
        this.generatedKeys = generatedKey;
    }

    @Override
    public GaussResultSetImpl getGeneratedKeyRows() {
        return this.generatedKeys;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void cancel() throws SQLException {
        GaussStatementHelper.cancel(this);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void clearWarnings() throws SQLException {
        this.validateOpened();
        this.sqlWarning = null;
    }

    public SQLWarning getSqlWarning() {
        return this.sqlWarning;
    }

    public void setSqlWarning(SQLWarning sqlWarning) {
        this.sqlWarning = sqlWarning;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.gaussConnection.closeStatement(this);
        try {
            if (this.statementId != -1) {
                GaussStatementHelper.closeStatement(this);
            }
        }
        finally {
            this.gaussConnection = null;
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean execute(String sql) throws SQLException {
        this.validateOpened();
        this.reset();
        return GaussStatementHelper.execute(this, sql);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.validateOpened();
        this.reset();
        return GaussStatementHelper.execute(this, sql, autoGeneratedKeys);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.validateOpened();
        this.reset();
        return GaussStatementHelper.execute(this, sql, columnIndexes);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.validateOpened();
        this.reset();
        return GaussStatementHelper.execute(this, sql, columnNames);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet executeQuery(String sql) throws SQLException {
        this.validateOpened();
        this.reset();
        this.currRowSize = 0;
        this.resultSet = (GaussResultSetImpl)GaussStatementHelper.executeQuery(this, sql);
        return this.resultSet;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int executeUpdate(String sql) throws SQLException {
        this.validateOpened();
        this.reset();
        this.updateCount = GaussStatementHelper.executeUpdate(this, sql);
        return this.updateCount;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.validateOpened();
        this.reset();
        this.updateCount = GaussStatementHelper.executeUpdate(this, sql, autoGeneratedKeys);
        return this.updateCount;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.validateOpened();
        this.reset();
        this.updateCount = GaussStatementHelper.executeUpdate(this, sql, columnIndexes);
        return this.updateCount;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.validateOpened();
        this.reset();
        this.updateCount = GaussStatementHelper.executeUpdate(this, sql, columnNames);
        return this.updateCount;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Connection getConnection() throws SQLException {
        this.validateOpened();
        return this.gaussConnection;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int getFetchDirection() throws SQLException {
        this.validateOpened();
        return 1000;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getFetchSize() throws SQLException {
        this.validateOpened();
        return this.fetchSize;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public int getMaxFieldSize() throws SQLException {
        this.validateOpened();
        return this.maxFieldSize;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxRows() throws SQLException {
        this.validateOpened();
        return this.maxRowSize;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean getMoreResults() throws SQLException {
        this.validateOpened();
        this.updateCount = -1;
        if (this.currentResultIndex >= this.returnResults.size()) {
            return false;
        }
        this.returnResults.get(this.currentResultIndex).close();
        ++this.currentResultIndex;
        return this.currentResultIndex < this.returnResults.size();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getQueryTimeout() throws SQLException {
        this.validateOpened();
        return this.userQueryTimeout / 1000;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getResultSet() throws SQLException {
        this.validateOpened();
        if (this.currentResultIndex >= this.returnResults.size()) {
            return null;
        }
        return this.returnResults.get(this.currentResultIndex);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int getResultSetConcurrency() throws SQLException {
        this.validateOpened();
        return 1007;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int getResultSetHoldability() throws SQLException {
        this.validateOpened();
        return 2;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int getResultSetType() throws SQLException {
        this.validateOpened();
        return 1003;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getUpdateCount() throws SQLException {
        this.validateOpened();
        return this.updateCount;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public SQLWarning getWarnings() throws SQLException {
        this.validateOpened();
        return this.sqlWarning;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isClosed() throws SQLException {
        return null == this.gaussConnection ? true : this.gaussConnection.isClosed();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean isPoolable() throws SQLException {
        this.validateOpened();
        return this.isPoolable;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.validateOpened();
        this.escapeProcess = enable;
    }

    public boolean isEscapeProcess() {
        return this.escapeProcess;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public void setFetchDirection(int direction) throws SQLException {
        this.validateOpened();
        if (direction != 1000) {
            throw ExceptionUtil.notSupportedFeature("Only support fetch direction is ResultSet.FETCH_FORWARD.");
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setFetchSize(int rows) throws SQLException {
        this.validateOpened();
        if (rows < 0) {
            throw ExceptionUtil.processJDBCException("Rows >= 0 is not satisfied, but rows is [" + rows + "].", "S1009", 501);
        }
        this.fetchSize = rows;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public void setMaxFieldSize(int max) throws SQLException {
        this.validateOpened();
        if (max < 0) {
            throw ExceptionUtil.processJDBCException("MaxFieldSize >= 0 is not satisfied, but maxFieldSize is [" + max + "].", "S1009", 501);
        }
        this.maxFieldSize = max;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setMaxRows(int max) throws SQLException {
        this.validateOpened();
        if (max < 0) {
            throw ExceptionUtil.processJDBCException("MaxRows >= 0 is not satisfied, but MaxRows is [" + max + "].", "S1009", 501);
        }
        this.maxRowSize = max;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public void setPoolable(boolean poolable) throws SQLException {
        this.validateOpened();
        this.isPoolable = poolable;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setQueryTimeout(int seconds) throws SQLException {
        this.validateOpened();
        if (seconds <= -1) {
            throw ExceptionUtil.processJDBCException("Seconds >= 0 is not satisfied, seconds is [" + seconds + "].", "S1009", 501);
        }
        this.userQueryTimeout = seconds * 1000;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isAutoCommit() {
        return this.gaussConnection.autoCommit;
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    @Override
    public void setStatementId(int statementId) {
        this.statementId = statementId;
    }

    @Override
    public void setResultSet(RowsData rowsData) {
        this.resultSet = new GaussResultSetImpl(this, null);
        this.gaussDriver.channelHandlerFactory.createResultSetCHandlers(this.resultSet.channelHandlers, this.gaussConnection);
        this.resultSet.setRowsData(rowsData);
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    @Override
    public int getLangType() {
        return this.langType;
    }

    @Override
    public void setLangType(int langType) {
        this.langType = langType;
    }

    @Override
    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    protected void reset() {
        this.resultSet = null;
        this.updateCount = -1;
        this.multiResultSets.clear();
        this.returnResults.clear();
        this.generatedKeys = null;
        this.currentResultIndex = 0;
    }

    void validateOpened() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionUtil.processJDBCException("Statement has been closed.", "42S22", 515);
        }
    }

    @Override
    public boolean isBigEndianess() {
        return this.gaussConnection.isBigEndianess();
    }

    @Override
    public boolean isPrepareStatement() {
        return false;
    }

    protected ResultSet getCursor(long cursorColumn) throws SQLException {
        int stmtId = (int)(cursorColumn >> 32);
        int fetchMode = (int)(cursorColumn & 0xFFFFFFFFFFFFFFFFL);
        GaussStatementImpl gaussStatement = (GaussStatementImpl)GaussConnectionHelper.createStatement(this.gaussConnection);
        gaussStatement.setStatementId(stmtId);
        GaussCursorResultSetImpl cursorResultSet = new GaussCursorResultSetImpl(gaussStatement, null, fetchMode);
        this.gaussConnection.getZenithDriver().getChannelHandlerFactory().createResultSetCHandlers(cursorResultSet.getChannelHandlers(), this.gaussConnection);
        cursorResultSet.fetchFirstPackage();
        return cursorResultSet;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Do not support addBatch at statement");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Do not support clearBatch at statement.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Do not support batch execute at statement");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getGeneratedKeys() throws SQLException {
        this.validateOpened();
        if (this.generatedKeys == null) {
            throw ExceptionUtil.illegalJDBCArgumentException("there is no generated key resultset");
        }
        return this.generatedKeys;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean getMoreResults(int current) throws SQLException {
        this.validateOpened();
        this.updateCount = -1;
        if (this.currentResultIndex >= this.returnResults.size()) {
            return false;
        }
        switch (current) {
            case 3: {
                for (int i = 0; i <= this.currentResultIndex; ++i) {
                    this.returnResults.get(i).close();
                }
                break;
            }
            case 1: {
                this.returnResults.get(this.currentResultIndex).close();
                break;
            }
            case 2: {
                break;
            }
            default: {
                ExceptionUtil.illegalJDBCArgumentException("invalid parameter value, current = " + current);
            }
        }
        ++this.currentResultIndex;
        return this.currentResultIndex < this.returnResults.size();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Do not support isWrapperFor.");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Do not support setCursorName");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Do not support unwrap at statement.");
    }

    @Override
    public boolean hasExecuted() {
        return this.hasExecuted && this.statementId != -1;
    }

    @Override
    public void setExecuted() {
        this.hasExecuted = true;
    }

    @Override
    public int[] getAffectedRows() {
        return this.affectedRows;
    }

    @Override
    public void setAffectedRows(int[] affectedRows) {
        this.affectedRows = (int[])affectedRows.clone();
    }

    @Override
    public RowsData.FieldDef[] getFieldDefs() {
        return this.fieldDefs;
    }

    @Override
    public void setFieldDefs(RowsData.FieldDef[] fieldDefs) {
        this.fieldDefs = fieldDefs;
    }

    public int getCurrRowSize() {
        return this.currRowSize;
    }

    public void setCurrRowSize(int currRowSize) {
        this.currRowSize = currRowSize;
    }

    public void incCurrRowSize() {
        ++this.currRowSize;
    }

    public boolean isReachMaxSize() {
        return this.maxRowSize == 0 ? false : this.currRowSize >= this.maxRowSize;
    }

    @Override
    public String getStmtUUID() {
        if (null == this.stmtUUID) {
            this.stmtUUID = this.gaussConnection.getStmtUUIDUtil().getUUID();
        }
        return this.stmtUUID.toString();
    }

    @Override
    public Properties getStmtProperties() {
        return this.stmtProperties;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public GaussParamDef[] getParamDefs() {
        return this.paramDefs;
    }

    @Override
    public void setParamDefs(GaussParamDef[] paramDefs) {
        this.paramDefs = paramDefs;
    }

    @Override
    public CallableParams getCallableParams() {
        return this.callableParams;
    }

    @Override
    public void setCallableParams(CallableParams callableParams) {
        this.callableParams = callableParams;
    }

    @Override
    public void addOneReturnResultSet(long cursorColumn) {
        this.multiResultSets.add(cursorColumn);
    }

    @Override
    public void fetchAllReturnResults() throws SQLException {
        for (Long cursorColumn : this.multiResultSets) {
            ResultSet oneResult = this.getCursor(cursorColumn);
            this.returnResults.add(oneResult);
        }
    }
}

