/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.util.BytesUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Arrays;

public abstract class AbstractMessage {
    public static final int FIX_HEAD_SIZE = 16;
    public static final int SUCCESS_RESULT_CODE = 0;
    public static final int BATCH_MAX_ERROR_COUNT = 10;
    protected static final int STRING_END_LEN = 1;
    protected static final byte STRING_END = 0;
    protected static final int DYNAMIC_DATA_LEN_SIZE = 2;
    protected static final int FOUR_BYTES_SIZE = 4;
    protected final FixHeader fixHeader = new FixHeader();
    protected final int FIX_HEADER_LEN = 16;
    protected ByteBuffer bodyBuffer;
    protected int sendMsgLen;
    protected Charset encodeCharset = BytesUtil.DEFAULT_CHERSET;
    protected final IOClient ioClient;
    protected final GaussConnection gaussConnection;
    protected final DefaultCHandlerContext<?> context;
    private int encodeMsgMsgLenPosition;

    public AbstractMessage(GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        this.gaussConnection = gaussConnection;
        this.ioClient = gaussConnection.getIOClient();
        this.context = context;
        this.fixAndOptionHeadValue();
    }

    protected abstract void fixAndOptionHeadValue();

    public boolean isError() {
        return this.fixHeader.resultCode != 0;
    }

    public int getSendMsgLen() {
        return this.sendMsgLen;
    }

    public DynamicByteBuffer encode(int encodeBufferSegmentSize) throws SQLException {
        DynamicByteBuffer buffer = new DynamicByteBuffer(this.gaussConnection.getIOClient().getByteOrder(), encodeBufferSegmentSize);
        try {
            this.encodeFixHeader(buffer);
            this.encodeOptionHead(buffer);
            this.encodeBody(buffer);
            this.encodeEnd(buffer);
            return buffer;
        }
        catch (SQLException ex) {
            buffer.clear();
            throw ex;
        }
        catch (Throwable throwable) {
            buffer.clear();
            throw this.getException("Encode msg failed.", throwable);
        }
    }

    public void decodeFixHeader(ByteBuffer buffer) throws SQLException {
        this.fixHeader.msgLen = buffer.getInt();
        this.fixHeader.cmdType = buffer.get();
        this.fixHeader.resultCode = buffer.get();
        this.fixHeader.headFlag = buffer.getShort();
        this.fixHeader.version = buffer.get();
        this.fixHeader.minorVersion = buffer.get();
        this.fixHeader.majorVersion = buffer.get();
        buffer.get();
        this.fixHeader.serialNumber = buffer.getInt();
    }

    protected byte[] decodeBytes4Align(ByteBuffer buffer) {
        int contentLen = buffer.getInt();
        int moreBytesLen = this.getAlign4Length(contentLen) - contentLen;
        byte[] data = new byte[contentLen];
        buffer.get(data);
        buffer.position(buffer.position() + moreBytesLen);
        return data;
    }

    public FixHeader getFixHeader() {
        return this.fixHeader;
    }

    public void setBodyBuffer(ByteBuffer bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
    }

    public ByteBuffer getBodyBuffer() {
        return this.bodyBuffer;
    }

    public void setEncodeCharset(Charset encodeCharset) {
        this.encodeCharset = encodeCharset;
    }

    protected void appendToString(StringBuilder builder) {
        builder.append(",AbstractMessage [fixHeader=");
        builder.append(this.fixHeader);
        builder.append(", encodeCharset=");
        builder.append(this.encodeCharset);
        builder.append("]");
    }

    protected abstract void encodeBody(DynamicByteBuffer var1) throws SQLException;

    protected void encodeDynamicStringWithEnd(DynamicByteBuffer buffer, String str) throws SQLException {
        byte[] bytes = str.getBytes(this.encodeCharset);
        buffer.putShort((short)(bytes.length + 1));
        buffer.put(bytes);
        buffer.put((byte)0);
    }

    protected void encodeFixLenString(DynamicByteBuffer buffer, String str, int length) throws SQLException {
        byte[] bytes = str.getBytes(this.encodeCharset);
        if (bytes.length >= length) {
            buffer.put(bytes, 0, length);
        } else {
            buffer.put(bytes);
            byte[] leftBytes = new byte[length - bytes.length];
            buffer.put(leftBytes);
        }
    }

    protected int getAlign4Length(int len) {
        if ((len & 3) == 0) {
            return len;
        }
        return len + 4 - (len & 3);
    }

    protected void encodeString4Align(DynamicByteBuffer buffer, String str) throws SQLException {
        this.encodeBytes4Align(buffer, str.getBytes(this.encodeCharset));
    }

    protected void encodeBytes4Align(DynamicByteBuffer buffer, byte[] data) throws SQLException {
        buffer.putInt(data.length);
        buffer.put(data);
        int alignLen = this.getAlign4Length(data.length);
        if (alignLen > data.length) {
            byte[] leftBytes = new byte[alignLen - data.length];
            Arrays.fill(leftBytes, (byte)0);
            buffer.put(leftBytes);
        }
    }

    public abstract int getMessageType();

    public abstract String getMessageTypeName();

    protected void encodeEnd(DynamicByteBuffer buffer) {
        int msgLen;
        this.sendMsgLen = msgLen = buffer.flip();
        buffer.putInt(this.encodeMsgMsgLenPosition, msgLen);
    }

    private void encodeFixHeader(DynamicByteBuffer buffer) throws SQLException {
        GaussConnectionImpl gaussConn = (GaussConnectionImpl)this.context.getGaussConnection();
        if (gaussConn.useRoute()) {
            this.fixHeader.setUseRoute();
        }
        this.encodeMsgMsgLenPosition = 0;
        buffer.putInt(this.fixHeader.msgLen);
        buffer.put(this.fixHeader.cmdType);
        buffer.put(this.fixHeader.resultCode);
        buffer.putShort(this.fixHeader.headFlag);
        buffer.put(this.fixHeader.version);
        buffer.put(this.fixHeader.minorVersion);
        buffer.put(this.fixHeader.majorVersion);
        buffer.put(this.fixHeader.reserved3);
        buffer.putInt(this.fixHeader.serialNumber);
    }

    public static void simpleRequestPacket(ByteBuffer buffer) throws SQLException {
        buffer.putInt(16);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.putShort((short)0);
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.putInt(0);
        buffer.flip();
    }

    private void encodeOptionHead(DynamicByteBuffer buffer) throws SQLException {
    }

    private JDBCException getException(String exceptionMssage, Throwable throwable) {
        int sessionId = -1;
        String gaussUrl = null;
        if (this.ioClient != null) {
            sessionId = this.ioClient.getSessionId();
            gaussUrl = this.ioClient.getZenithUrl();
        }
        JDBCException exception = null;
        exception = throwable != null ? ExceptionUtil.illegalJDBCArgumentException(exceptionMssage, throwable) : ExceptionUtil.illegalJDBCArgumentException(exceptionMssage);
        exception.setZenithServerIp(gaussUrl);
        exception.setSessionId(sessionId);
        return exception;
    }

    public GaussConnection getConnection() {
        return this.gaussConnection;
    }

    public DefaultCHandlerContext<?> getContext() {
        return this.context;
    }

    public static class FixHeader {
        public static final byte CS_VERSION_0 = 0;
        public static final byte CS_VERSION_1 = 1;
        public static final byte CS_VERSION_2 = 2;
        public static final byte CS_VERSION_3 = 3;
        public static final byte CS_VERSION_4 = 4;
        public static final byte CS_VERSION_5 = 5;
        public static final byte CS_VERSION_6 = 6;
        public static final byte CS_VERSION_7 = 7;
        public static final byte CS_VERSION_8 = 8;
        public static final byte CS_VERSION_9 = 9;
        public static final byte CS_VERSION_10 = 10;
        public static final short FLAG_MORE_DATA = 1;
        public static final short FLAG_PEER_CLOSED = 2;
        public static final short FLAG_SERVEROUTPUT = 4;
        public static final short FLAG_PL_OUTPUT_PARAM = 8;
        public static final short FLAG_RETURN_GENERATED_KEY = 16;
        public static final short FLAG_RETURN_RESULTSET = 256;
        public static final short FLAG_CLIENT_SSL = 512;
        public static final short FLAG_CN_USE_ROUTE = 2048;
        public static final int LOCAL_MAJOR_VER_WEIGHT = 1000000;
        public static final short LOCAL_MINOR_VER_WEIGHT = 1000;
        public static final byte LOCAL_MAJOR_VERSION = 0;
        public static final byte LOCAL_MINOR_VERSION = 0;
        public static final byte LOCAL_VERSION = 10;
        protected static final int CURRENT_VERSION = 10;
        protected static final short DEFAULT_HEAD_FLAG = 0;
        protected static final byte DEFAULT_RESERVED = 0;
        protected byte minorVersion = 0;
        protected byte majorVersion = 0;
        protected byte reserved1 = 0;
        protected byte reserved2 = 0;
        protected byte reserved3 = 0;
        protected int msgLen;
        protected byte cmdType;
        protected byte resultCode;
        protected short headFlag = 0;
        protected int serialNumber;
        private byte version = (byte)10;

        public int getMsgLen() {
            return this.msgLen;
        }

        public int getOptionHeadAndBodyLen() {
            return this.msgLen - 16;
        }

        public int getResultCode() {
            return this.resultCode;
        }

        public boolean hasOutputParams() {
            boolean result = false;
            if ((this.headFlag & 8) != 0) {
                result = true;
            }
            return result;
        }

        public void setReturnGeneratedKeyFlag() {
            this.headFlag = (short)(this.headFlag | 0x10);
        }

        public boolean hasReturnResultSet() {
            return (this.headFlag & 0x100) != 0;
        }

        public void setClientSSL() {
            this.headFlag = (short)(this.headFlag | 0x200);
        }

        public boolean hasClientSSL() {
            return (this.headFlag & 0x200) != 0;
        }

        public void setUseRoute() {
            this.headFlag = (short)(this.headFlag | 0x800);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FixHeader [cmdType=");
            builder.append(this.cmdType);
            builder.append(", serialNumber=");
            builder.append(this.serialNumber);
            builder.append(", version=");
            builder.append(this.version);
            builder.append(", resultCode=");
            builder.append(this.resultCode);
            builder.append(", msgLen=");
            builder.append(this.msgLen);
            builder.append("]");
            return builder.toString();
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }
    }
}

