/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.channel.context.statement.AbstractExecuteContext;
import com.huawei.gauss.channel.context.statement.ParamsData;
import com.huawei.gauss.channel.context.statement.ParamsDataProcessor;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.util.BytesUtil;
import java.sql.SQLException;

public class ExecuteRequest
extends AbstractCommonRequest {
    protected int batchCount = 1;
    protected int batchCountPosition = -1;

    public ExecuteRequest(GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
    }

    @Override
    protected void fixAndOptionHeadValue() {
        super.fixAndOptionHeadValue();
        AbstractExecuteContext executeCtx = (AbstractExecuteContext)this.context;
        if (executeCtx.getAutoGeneratedKeys() == 1) {
            this.fixHeader.setReturnGeneratedKeyFlag();
        }
    }

    @Override
    protected void encodeBody(DynamicByteBuffer buffer) throws SQLException {
        this.encodeStatementId(buffer);
        this.encodeDifferentSigment(buffer);
        this.encodeParams(buffer);
    }

    protected void encodeDifferentSigment(DynamicByteBuffer buffer) throws SQLException {
        AbstractExecuteContext tempContext = (AbstractExecuteContext)this.context;
        this.batchCount = tempContext.getBatchCount();
        this.batchCountPosition = buffer.position();
        this.encodeSessionAttr(buffer, tempContext);
        buffer.put(this.fixHeader.reserved1);
        this.encodeRouteInfo(buffer);
    }

    protected void encodeSessionAttr(DynamicByteBuffer buffer, AbstractExecuteContext<?> context) throws SQLException {
        buffer.putShort((short)context.getBatchCount());
        int fetchSize = context.getStatement().getFetchSize();
        if (fetchSize > Short.MAX_VALUE) {
            fetchSize = 0;
        }
        buffer.putShort((short)fetchSize);
        byte autoCommit = context.getGaussConnection().getAutoCommit() ? (byte)1 : 0;
        buffer.put(autoCommit);
    }

    protected void encodeRouteInfo(DynamicByteBuffer buffer) throws SQLException {
        GaussConnectionImpl gaussConn = (GaussConnectionImpl)this.context.getGaussConnection();
        if (gaussConn.useRoute()) {
            if (gaussConn.isRouteChanged()) {
                String routeSQL = gaussConn.getRouteSQL();
                this.encodeSql(buffer, routeSQL);
                gaussConn.saveLastRouteArgs(gaussConn.getClientInfo());
            } else {
                buffer.putInt(0);
            }
        }
    }

    protected void encodeSql(DynamicByteBuffer buffer, String routeSQL) throws SQLException {
        byte[] sqlData = routeSQL.getBytes(this.encodeCharset);
        int sqlLen = sqlData.length;
        buffer.putInt(sqlLen);
        int align4BytesSqlLength = BytesUtil.align4BytesLength(sqlLen);
        byte[] tempSql = new byte[align4BytesSqlLength];
        System.arraycopy(sqlData, 0, tempSql, 0, sqlData.length);
        buffer.put(tempSql);
    }

    @Override
    protected void encodeEnd(DynamicByteBuffer buffer) {
        super.encodeEnd(buffer);
        if (this.batchCountPosition != -1) {
            buffer.putShort(this.batchCountPosition, (short)this.batchCount);
        }
    }

    protected void encodeParams(DynamicByteBuffer buffer) throws SQLException {
        ParamsData paramsData = ((AbstractExecuteContext)this.context).getParamsData();
        if (paramsData != null) {
            ParamsDataProcessor processor = paramsData.getProcessor();
            boolean hasNextPackage = false;
            boolean leastOnce = false;
            while (!processor.isEnd() || processor.hasNextParam()) {
                byte[] paramToServer = processor.getParamEncodeValue();
                if (buffer.capacity() + paramToServer.length <= 98304 || !leastOnce) {
                    buffer.put(paramToServer);
                    processor.setUsedBufferLen(buffer.capacity());
                    leastOnce = true;
                    processor.reset();
                    continue;
                }
                hasNextPackage = true;
                processor.addTypelistToEncodeData();
                break;
            }
            this.batchCount = paramsData.getBatchCount();
            paramsData.markPosition();
            if (hasNextPackage) {
                paramsData.decreaseMark();
                --this.batchCount;
            }
        }
    }

    @Override
    public int getMessageType() {
        return 5;
    }

    @Override
    public String getMessageTypeName() {
        return "ExecuteRequest";
    }
}

