/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.channel.context.statement.AbstractExecuteContext;
import com.huawei.gauss.channel.context.statement.CallableParams;
import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonResponse;
import com.huawei.gauss.util.BytesUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.List;

public class ExecuteResponse
extends AbstractCommonResponse {
    protected static final int HAS_RESULT_SET = 1;
    protected static final int EMPTY_DATA_COUNT = 0;
    protected static final int NULL_LENGTH = 0;
    protected static final int FOUR_LENGTH = 1;
    protected static final int EIGHT_LENGTH = 2;
    protected static final int CHANGE_LENGTH = 3;

    public ExecuteResponse(GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
    }

    @Override
    void decodeGmdbBodyMsg(ByteBuffer buffer, GaussInfo gaussInfo) throws SQLException {
        int langType = this.context.getStatement().getLangType();
        int[] affectedRows = new int[]{0};
        if (langType == 3 || langType == 2) {
            ((AbstractExecuteContext)this.context).setAffectedRows(affectedRows);
            return;
        }
        buffer.getInt();
        affectedRows[0] = buffer.getInt();
        this.context.getStatement().setUpdateCount(affectedRows[0]);
        this.decodeOutParamsAndRows(buffer);
        ((AbstractExecuteContext)this.context).setAffectedRows(affectedRows);
    }

    protected void decodeStatementIdAndType(ByteBuffer buffer) {
        short stmtId = buffer.getShort();
        this.context.getStatement().setStatementId(stmtId);
        short statementType = buffer.getShort();
        int sqlType = statementType & 0xFFF;
        int langType = statementType >> 12 & 0xF;
        this.context.getStatement().setSqlType(sqlType);
        this.context.getStatement().setLangType(langType);
    }

    protected void decodeParamAndField(ByteBuffer buffer) throws SQLException {
        AbstractExecuteContext ctx = (AbstractExecuteContext)this.context;
        int columnCount = buffer.getShort();
        byte[] ba = new byte[2];
        buffer.get(ba);
        int paramCount = BytesUtil.toUnsignedShort(ba, 0, ctx.getGaussConnection().isBigEndianess());
        for (int i = 0; i < paramCount; ++i) {
            buffer.getInt();
            buffer.getInt();
        }
        RowsData.FieldDef[] fieldDefs = new RowsData.FieldDef[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            fieldDefs[i] = new RowsData.FieldDef(buffer, false);
        }
        GaussStatement stmt = ctx.getStatement();
        stmt.setFieldDefs(fieldDefs);
        if (this.context.getStatement().getLangType() == 4) {
            CallableParams callableParams = new CallableParams(this.context.getStatement());
            callableParams.decodeCallableParamDefs(buffer);
            this.context.getStatement().setCallableParams(callableParams);
        }
    }

    protected void decodeOutParamsAndRows(ByteBuffer buffer) throws SQLException {
        boolean haveResultSet;
        RowsData.FieldDef[] fieldDefs = this.context.getStatement().getFieldDefs();
        int columnCount = this.context.getStatement().getFieldDefs().length;
        short rowCount = buffer.getShort();
        byte hasMoreRow = buffer.get();
        buffer.get();
        boolean bl = haveResultSet = rowCount > 0;
        if (this.context.getStatement().getSqlType() == 1 || this.context.getStatement().getLangType() == 4) {
            this.context.getStatement().setUpdateCount(-1);
        }
        RowsData.FieldDef[] finalfFieldDefs = null;
        int finalColumnDefsCount = buffer.getShort();
        buffer.getShort();
        if (haveResultSet) {
            finalfFieldDefs = new RowsData.FieldDef[finalColumnDefsCount];
            for (int i = 0; i < finalColumnDefsCount; ++i) {
                finalfFieldDefs[i] = new RowsData.FieldDef(buffer, true);
            }
        }
        if (this.context.getStatement().getLangType() == 4) {
            List<Long> listCursors = ((AbstractExecuteContext)this.context).getMultiResultSets();
            for (Long cursor : listCursors) {
                this.context.getStatement().addOneReturnResultSet(cursor);
            }
        }
        if (this.context.getStatement().getLangType() == 4 && this.getFixHeader().hasOutputParams()) {
            CallableParams callableParams = this.context.getStatement().getCallableParams();
            callableParams.decodeCallableOutParamValues(buffer);
        }
        if (columnCount > 0) {
            RowsData.RowData[] rows = RowsData.NULL_ROWS_DATA;
            if (haveResultSet) {
                rows = this.parseToDataRows(rowCount, buffer);
            }
            RowsData rowsData = new RowsData(fieldDefs, rows, hasMoreRow, this.gaussConnection.getIOClient().getByteOrder(), this.gaussConnection);
            rowsData.setFinalDefs(finalfFieldDefs);
            ((AbstractExecuteContext)this.context).setRowsData(rowsData);
        }
        this.decodeGeneratedKeys(buffer, rowCount);
    }

    private void decodeGeneratedKeys(ByteBuffer buffer, int rowCount) throws SQLException {
        AbstractExecuteContext executeCtx = (AbstractExecuteContext)this.context;
        RowsData.RowData[] rows = RowsData.NULL_ROWS_DATA;
        if (executeCtx.getAutoGeneratedKeys() != 1) {
            executeCtx.setGeneratedKeyRowsData(null);
        } else if ((this.context.getStatement().getSqlType() == 3 || this.context.getStatement().getSqlType() == 5) && rowCount > 0) {
            rows = this.parseToDataRows(rowCount, buffer);
        }
        RowsData.FieldDef[] fieldDefs = new RowsData.FieldDef[]{new RowsData.FieldDef()};
        fieldDefs[0].setFieldType(FieldType.BIGINT);
        fieldDefs[0].setColumnName("GENERATED_KEY");
        int hasMoreRow = 0;
        RowsData rowsData = new RowsData(fieldDefs, rows, hasMoreRow, this.gaussConnection.getIOClient().getByteOrder(), this.gaussConnection);
        executeCtx.setGeneratedKeyRowsData(rowsData);
    }

    protected RowsData.RowData[] parseToDataRows(int rowCount, ByteBuffer bb) {
        RowsData.RowData[] rows = new RowsData.RowData[rowCount];
        int actualColCount = -1;
        int bitsLen = -1;
        byte[] bitsLenBytes = null;
        for (int i = 0; i < rowCount; ++i) {
            bb.getShort();
            short colCount = bb.getShort();
            if (colCount == 0) {
                colCount = bb.getShort();
                if (actualColCount == -1) {
                    actualColCount = colCount;
                    bitsLen = 1 + ((actualColCount - 4 + 15 & 0xFFFFF0) >> 2);
                    bitsLenBytes = new byte[bitsLen];
                }
            } else if (actualColCount == -1) {
                actualColCount = colCount;
                bitsLen = actualColCount <= 12 ? 3 : 3 + ((actualColCount - 12 + 15 & 0xFFFFF0) >> 2);
                bitsLenBytes = new byte[bitsLen];
            }
            RowsData.FieldValue[] rowValues = new RowsData.FieldValue[actualColCount];
            RowsData.RowData rowData = new RowsData.RowData(rowValues);
            bb.get();
            bb.get(bitsLenBytes);
            int columnFlag = -1;
            for (int j = 0; j < actualColCount; ++j) {
                if (j % 4 == 0) {
                    columnFlag = bitsLenBytes[j >> 2];
                }
                switch (columnFlag & 3) {
                    case 0: {
                        rowValues[j] = new RowsData.FieldValue(-1, new byte[0]);
                        break;
                    }
                    case 1: {
                        byte[] bytes4 = new byte[4];
                        bb.get(bytes4);
                        rowValues[j] = new RowsData.FieldValue(4, bytes4);
                        break;
                    }
                    case 2: {
                        byte[] bytes8 = new byte[8];
                        bb.get(bytes8);
                        rowValues[j] = new RowsData.FieldValue(8, bytes8);
                        break;
                    }
                    case 3: {
                        byte[] len = new byte[2];
                        bb.get(len);
                        int curColumnLength = BytesUtil.toUnsignedShort(len, 0, bb.order().equals(ByteOrder.BIG_ENDIAN));
                        int curColumnTmp = curColumnLength + (4 - (curColumnLength + 2) % 4) % 4;
                        byte[] bytes = new byte[curColumnTmp];
                        bb.get(bytes);
                        rowValues[j] = new RowsData.FieldValue(curColumnLength, bytes);
                        break;
                    }
                }
                columnFlag >>= 2;
            }
            rows[i] = rowData;
        }
        return rows;
    }

    @Override
    public int getMessageType() {
        return 5;
    }

    @Override
    public String getMessageTypeName() {
        return "ExecuteResponse";
    }
}

