/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.channel.context.statement.FetchLobDataContext;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import java.sql.SQLException;

public class FetchLobDataRequest
extends AbstractCommonRequest {
    public FetchLobDataRequest(GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
    }

    @Override
    protected void encodeBody(DynamicByteBuffer buffer) throws SQLException {
        this.encodeStatementId(buffer);
        buffer.put(this.fixHeader.reserved1);
        buffer.put(this.fixHeader.reserved2);
        AbstractGaussLob lob = ((FetchLobDataContext)this.context).getGaussLob();
        buffer.putInt(64512);
        int lobOffset = lob.getServerOffset();
        buffer.putInt(lobOffset);
        byte[] lobHandler = lob.getLobHandler();
        buffer.put(lobHandler);
        int locatorSize = this.ioClient.getLocatorSize();
        if (lobHandler.length < locatorSize) {
            byte[] leftReserved = new byte[locatorSize - lobHandler.length];
            buffer.put(leftReserved);
        }
    }

    @Override
    public int getMessageType() {
        return 13;
    }

    @Override
    public String getMessageTypeName() {
        return "FetchLobDataRequest";
    }
}

