/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.AuthInitRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.util.EncryptUtil;
import java.sql.SQLException;

public class HandshakeRequest
extends AbstractCommonRequest {
    private String userName;
    private byte[] clientKey;

    public HandshakeRequest(int clientFlag, GaussConnection gaussConnection, DefaultCHandlerContext<?> context) throws SQLException {
        super(gaussConnection, context);
        int serverCapabilities = 0;
        if ((clientFlag & 0x200) != 0) {
            serverCapabilities |= 0x200;
        }
        this.userName = gaussConnection.getClientInfo("user");
        this.ioClient.setServerCapabilities(serverCapabilities);
        this.clientKey = EncryptUtil.generateChallenge();
    }

    @Override
    public void encodeBody(DynamicByteBuffer buffer) throws SQLException {
        if (this.ioClient.getServerVersion() >= 9) {
            buffer.putInt(this.ioClient.getClientFlag());
        } else {
            this.encodeString4Align(buffer, this.userName);
            buffer.putInt(this.ioClient.getClientFlag());
            this.encodeBytes4Align(buffer, this.clientKey);
        }
    }

    @Override
    public int getMessageType() {
        return 19;
    }

    public byte[] getClientKey() {
        return (byte[])this.clientKey.clone();
    }

    public AbstractCommonRequest getAuthInitRequest() throws SQLException {
        return new AuthInitRequest(this.clientKey, this.gaussConnection, this.context);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HandshakeRequest [clientFlag=");
        builder.append(this.ioClient.getClientFlag());
        builder.append(", userName=");
        builder.append(this.userName);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getMessageTypeName() {
        return "HandshakeRequest";
    }
}

