/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.LoginRequest;
import com.huawei.gauss.util.BytesUtil;
import com.huawei.gauss.util.EncryptUtil;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Arrays;

public class LoginResponse
extends AbstractCommonResponse {
    private final LoginRequest request;

    public LoginResponse(LoginRequest loginRequest, GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
        this.request = loginRequest;
    }

    @Override
    public int getMessageType() {
        return 1;
    }

    @Override
    void decodeGmdbBodyMsg(ByteBuffer buffer, GaussInfo gaussInfo) throws SQLException {
        this.ioClient.setSessionId(buffer.getInt());
        this.ioClient.setSessionSeqNo(buffer.getInt());
        this.ioClient.setLocatorSize(buffer.getInt());
        this.ioClient.setCharset(buffer.getInt());
        byte[] serverSignature = this.decodeBytes4Align(buffer);
        if (!this.verifyScramSHA256Signature(serverSignature)) {
            throw new JDBCException("Verify server signature failed");
        }
        if (this.ioClient.getServerVersion() >= 10) {
            this.ioClient.setMaxAllowedPacket(buffer.getInt());
        }
    }

    private boolean verifyScramSHA256Signature(byte[] serverSignature) throws SQLException {
        byte[] signKey = new byte[64];
        System.arraycopy(this.request.getScramKey(), 0, signKey, 0, signKey.length);
        byte[] serverKey = EncryptUtil.encryptHmacSHA256(this.request.getEncryptPasswd(), "Zenith_Server_Key".getBytes(BytesUtil.DEFAULT_CHERSET));
        byte[] expectedSignature = EncryptUtil.encryptHmacSHA256(serverKey, signKey);
        return Arrays.equals(expectedSignature, serverSignature);
    }

    @Override
    public String getMessageTypeName() {
        return "LoginResponse";
    }
}

