/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.channel.context.connection.XArollbackContext;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.util.BytesUtil;
import java.sql.SQLException;

public class XArollbackRequest
extends AbstractCommonRequest {
    public XArollbackRequest(GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
    }

    @Override
    protected void encodeBody(DynamicByteBuffer buffer) throws SQLException {
        XArollbackContext xaRollbackContext = (XArollbackContext)this.context;
        boolean isBigEndian = this.gaussConnection.getIOClient().isBigEndian();
        int xidLen = 0;
        buffer.putInt(xidLen);
        long temp = xaRollbackContext.getXid().getFormatId();
        byte[] formatBytes = BytesUtil.getBytes(temp, isBigEndian);
        buffer.put(formatBytes);
        byte[] globalTrxId = xaRollbackContext.getXid().getGlobalTransactionId();
        int globalTrxIdLen = globalTrxId.length;
        buffer.put((byte)globalTrxIdLen);
        byte[] branchQulifier = xaRollbackContext.getXid().getBranchQualifier();
        int branchQulifierLen = branchQulifier.length;
        buffer.put((byte)branchQulifierLen);
        buffer.put(globalTrxId);
        buffer.put(branchQulifier);
        xidLen = 10 + globalTrxIdLen + branchQulifierLen;
        int align4BytesSqlLength = BytesUtil.align4BytesLength(xidLen);
        byte[] makeUpBytes = new byte[align4BytesSqlLength - xidLen];
        buffer.put(makeUpBytes);
        buffer.putInt(16, xidLen);
        buffer.put(BytesUtil.getBytes(0L, isBigEndian));
    }

    @Override
    public int getMessageType() {
        return 17;
    }

    @Override
    public String getMessageTypeName() {
        return "XArollbackRequest";
    }
}

