/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.om;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.om.OMConstants;
import com.huawei.gauss.om.PropertyLoader;
import java.io.IOException;
import java.util.Properties;

public class ConfigManager {
    static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    private Properties properties = new Properties();
    private Configs configs;

    private ConfigManager() {
        try {
            PropertyLoader.loadResourceProperties(this.properties, "zenith.jdbc.inner.properties");
        }
        catch (IOException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when load property", e);
        }
        try {
            PropertyLoader.loadSystemProperties(this.properties, "zenith.jdbc.properties");
        }
        catch (IOException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when load property", e);
        }
        this.configs = new Configs();
    }

    public static final ConfigManager getInstance() {
        return CONFIG_MANAGER;
    }

    public int getULoginTimeout() {
        return this.configs.uLoginTimeout;
    }

    public int getUSocketTimeout() {
        return this.configs.uSocketTimeout;
    }

    public boolean getUSocketTCPNoDelay() {
        return this.configs.uSocketTCPNoDelay;
    }

    public int getUSocketSendBufferSize() {
        return this.configs.uSocketTCPSendBufferSize;
    }

    public boolean getUCheckFeatureNotSupported() {
        return this.configs.uCheckFeatureNotSupported;
    }

    public int getUSocketReceiveBufferSize() {
        return this.configs.uSocketTCPReceiveBufferSize;
    }

    public int getBufferSegmentSize() {
        return this.configs.uBufferSegmentSize;
    }

    public String getClientKeyStore() {
        return this.configs.uClientCertKeyStore;
    }

    public String getClientKeyStoreType() {
        return this.configs.uClientCertKeyStoreType;
    }

    public String getClientKeyStorePassword() {
        return this.configs.uClientCertKeyStorePassword;
    }

    public String getTrustKeyStore() {
        return this.configs.uTrustCertKeyStore;
    }

    public String getTrustKeyStoreType() {
        return this.configs.uTrustCertKeyStoreType;
    }

    public String getEnabledSSLCipherSuites() {
        return this.configs.uEnabledSSLCipherSuites;
    }

    public String getTrustKeyStorePassword() {
        return this.configs.uTrustCertKeyStorePassword;
    }

    private class Configs
    implements OMConstants {
        private int uLoginTimeout;
        private int uSocketTimeout;
        private boolean uSocketTCPNoDelay;
        private int uSocketTCPSendBufferSize;
        private int uSocketTCPReceiveBufferSize;
        private boolean uCheckFeatureNotSupported;
        private int uBufferSegmentSize;
        private String uClientCertKeyStore;
        private String uClientCertKeyStoreType;
        private String uClientCertKeyStorePassword;
        private String uTrustCertKeyStore;
        private String uTrustCertKeyStoreType;
        private String uTrustCertKeyStorePassword;
        private String uEnabledSSLCipherSuites;

        private Configs() {
            this.uLoginTimeout = Integer.parseInt(ConfigManager.this.properties.getProperty("zenith.jdbc.loginTimeout", "0"));
            this.uSocketTimeout = Integer.parseInt(ConfigManager.this.properties.getProperty("zenith.jdbc.socketTimeout", "0"));
            this.uSocketTCPNoDelay = Boolean.parseBoolean(ConfigManager.this.properties.getProperty("zenith.jdbc.socket.tcpnodelay", "true"));
            this.uSocketTCPSendBufferSize = Integer.parseInt(ConfigManager.this.properties.getProperty("zenith.jdbc.socket.tcpsendbuffersize", "98304"));
            this.uSocketTCPReceiveBufferSize = Integer.parseInt(ConfigManager.this.properties.getProperty("zenith.jdbc.socket.tcpreceivebuffersize", "131072"));
            this.uCheckFeatureNotSupported = Boolean.parseBoolean(ConfigManager.this.properties.getProperty("zenith.jdbc.checkfeaturenotsupported", "true"));
            this.uBufferSegmentSize = Integer.parseInt(ConfigManager.this.properties.getProperty("zenith.jdbc.socket.buffersegmentsize", "8192"));
            this.uClientCertKeyStore = ConfigManager.this.properties.getProperty("zenith.jdbc.ssl.keyStore", "");
            this.uClientCertKeyStoreType = ConfigManager.this.properties.getProperty("zenith.jdbc.ssl.keyStoreType", "JKS");
            this.uClientCertKeyStorePassword = ConfigManager.this.properties.getProperty("zenith.jdbc.ssl.keyStorePassword", "");
            this.uTrustCertKeyStore = ConfigManager.this.properties.getProperty("zenith.jdbc.ssl.trustStore", "");
            this.uTrustCertKeyStoreType = ConfigManager.this.properties.getProperty("zenith.jdbc.ssl.trustStoreType", "JKS");
            this.uTrustCertKeyStorePassword = ConfigManager.this.properties.getProperty("zenith.jdbc.ssl.trustStorePassword", "");
            this.uEnabledSSLCipherSuites = ConfigManager.this.properties.getProperty("zenith.jdbc.ssl.ciphers", "");
        }
    }
}

