/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.util;

import com.huawei.gauss.exception.ExceptionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ByteBufferUtil {
    static Method getBufferMethod = null;
    static Method releaseBuffMethod = null;

    public static ByteBuffer getDirectByteBuffer(int size) {
        ByteBuffer byteBuffer = null;
        if (null != getBufferMethod) {
            try {
                byteBuffer = (ByteBuffer)getBufferMethod.invoke(null, size);
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when get byteBuffer", e);
            }
            catch (IllegalArgumentException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when get byteBuffer", e);
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when get byteBuffer", e);
            }
        }
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocateDirect(size);
        }
        return byteBuffer;
    }

    public static void releaseDirectByteBuffer(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return;
        }
        boolean isbackToPool = false;
        if (null != releaseBuffMethod) {
            try {
                releaseBuffMethod.invoke(null, buffer);
                isbackToPool = true;
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
            }
            catch (IllegalArgumentException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
            }
        }
        if (!isbackToPool) {
            ByteBufferUtil.doReleaseByteBuffer(buffer);
        }
    }

    private static void doReleaseByteBuffer(final ByteBuffer buffer) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                    Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                    cleanMethod.invoke(cleaner, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
                }
                catch (SecurityException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
                }
                catch (IllegalAccessException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
                }
                catch (IllegalArgumentException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
                }
                catch (InvocationTargetException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when release byteBuffer", e);
                }
                return null;
            }
        });
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Class<?> bufferCacheClass = Class.forName("sun.nio.ch.Util");
                    getBufferMethod = bufferCacheClass.getDeclaredMethod("getTemporaryDirectBuffer", Integer.TYPE);
                    getBufferMethod.setAccessible(true);
                    releaseBuffMethod = bufferCacheClass.getDeclaredMethod("releaseTemporaryDirectBuffer", ByteBuffer.class);
                    releaseBuffMethod.setAccessible(true);
                }
                catch (ClassNotFoundException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when init byteBuffer", e);
                }
                catch (SecurityException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when init byteBuffer", e);
                }
                catch (NoSuchMethodException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when init byteBuffer", e);
                }
                return null;
            }
        });
    }
}

