/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.util;

import com.huawei.gauss.util.FormatTransfer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Arrays;

public abstract class BytesUtil {
    public static final byte[] EMPTY = new byte[0];
    public static final int NULL_LENGTH = -1;
    public static final Charset DEFAULT_CHERSET = Charset.forName("UTF-8");
    static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final int[][] DAYS_OF_MONTH = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    static final int LINE_CHAR_COUNT = 16;
    static final int SHORT_BYTES = 2;
    static final int INT_BYTES = 4;
    static final int LONG_BYTES = 8;
    static final double MILLISECS_IN_ONE_DAY = 8.64E7;
    static final int DAYS_1 = 365;
    static final int DAYS_4 = 1461;
    static final int DAYS_100 = 36524;
    static final int DAYS_400 = 146097;
    static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1");
    static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal("0");
    static final BigDecimal BIGDECIMAL_NEGATIVE_ONE = new BigDecimal("-1");
    static final byte INFINITY_TO_NEGATIVEONE = 0;
    static final byte NEGATIVEONE_TO_ZERO = 64;
    static final byte ZERO_TO_ONE = -128;
    static final byte ONE_TO_INFINITY = -64;
    static final int BIGDECIMAL_MAX_EFFECTIVE_NUM = 38;

    public static byte[] getBytes(long value, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.toBE(value);
        }
        return FormatTransfer.toLE(value);
    }

    public static byte[] getBytes(int value, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.toBE(value);
        }
        return FormatTransfer.toLE(value);
    }

    public static byte[] getBytes(short value, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.toBE(value);
        }
        return FormatTransfer.toLE(value);
    }

    public static byte[] getBytes(double value) {
        return FormatTransfer.toLE(value);
    }

    public static byte[] getBytes(float value) {
        return FormatTransfer.toLE(value);
    }

    public static byte[] getBytes(boolean value, boolean isBigEndianess) {
        int boolInt = 0;
        if (value) {
            boolInt = 1;
        }
        if (isBigEndianess) {
            return FormatTransfer.toBE(boolInt);
        }
        return FormatTransfer.toLE(boolInt);
    }

    private static int isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? 1 : 0;
    }

    public static String toString(byte[] bytes) throws SQLException {
        return BytesUtil.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        int i;
        int end = offset + length;
        for (i = offset; i < end && bytes[i] != 0; ++i) {
        }
        return new String(Arrays.copyOfRange(bytes, offset, i), DEFAULT_CHERSET);
    }

    public static int[] getYearMonDay(int days) {
        int innerDays = days;
        --innerDays;
        int[] result = new int[3];
        result[0] = 1;
        while (innerDays >= 146097) {
            result[0] = result[0] + 400;
            innerDays -= 146097;
        }
        while (innerDays >= 36524) {
            result[0] = result[0] + 100;
            innerDays -= 36524;
        }
        while (innerDays >= 1461) {
            result[0] = result[0] + 4;
            innerDays -= 1461;
        }
        while (innerDays >= 365) {
            if (BytesUtil.isLeapYear(result[0]) == 1 && --innerDays < 365) {
                ++innerDays;
                break;
            }
            result[0] = result[0] + 1;
            innerDays -= 365;
        }
        if (innerDays == 0) {
            result[0] = result[0] - 1;
            result[1] = 11;
            result[2] = 31;
        } else {
            int[] dayOfMonth = DAYS_OF_MONTH[BytesUtil.isLeapYear(result[0])];
            result[1] = 0;
            while (innerDays > dayOfMonth[result[1]]) {
                innerDays -= dayOfMonth[result[1]];
                result[1] = result[1] + 1;
            }
            result[2] = innerDays;
        }
        return result;
    }

    public static void validateBytesLen(byte[] bytes, int length) {
        if (bytes.length > length) {
            throw new IllegalArgumentException("Invalid input array, current bytes length is " + bytes.length + ". But should be :" + length);
        }
    }

    public static long toLong(byte[] byte8, boolean isBigEndianess) {
        BytesUtil.validateBytesLen(byte8, 8);
        if (isBigEndianess) {
            return FormatTransfer.beBytesToLong(byte8);
        }
        return FormatTransfer.leBytesToLong(byte8);
    }

    public static long toLong(byte[] byte8, int offset, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.beBytesToLong(byte8, offset);
        }
        return FormatTransfer.leBytesToLong(byte8, offset);
    }

    public static long toUnsignedInt(byte[] byte4, int offset, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.beBytesToUnsignedInt(byte4, offset);
        }
        return FormatTransfer.leBytesToUnsignedInt(byte4, offset);
    }

    public static int toInt(byte[] byte4, boolean isBigEndianess) {
        BytesUtil.validateBytesLen(byte4, 4);
        if (isBigEndianess) {
            return FormatTransfer.beBytesToInt(byte4);
        }
        return FormatTransfer.leBytesToInt(byte4);
    }

    public static int toInt(byte[] byte4, int offset, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.beBytesToInt(byte4, offset);
        }
        return FormatTransfer.leBytesToInt(byte4, offset);
    }

    public static short toShort(byte[] byte2, boolean isBigEndianess) {
        BytesUtil.validateBytesLen(byte2, 2);
        if (isBigEndianess) {
            return FormatTransfer.beBytesToShort(byte2);
        }
        return FormatTransfer.leBytesToShort(byte2);
    }

    public static int toUnsignedShort(byte[] byte2, int offset, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.beBytesToUnsignedShort(byte2, offset);
        }
        return FormatTransfer.leBytesToUnsignedShort(byte2, offset);
    }

    public static short toShort(byte[] byte2, int offset, boolean isBigEndianess) {
        if (isBigEndianess) {
            return FormatTransfer.beBytesToShort(byte2, offset);
        }
        return FormatTransfer.leBytesToShort(byte2, offset);
    }

    public static double toDouble(byte[] byte8) {
        BytesUtil.validateBytesLen(byte8, 8);
        return FormatTransfer.leBytesToDouble(byte8);
    }

    public static float toFloat(byte[] byte4) {
        BytesUtil.validateBytesLen(byte4, 4);
        return FormatTransfer.leBytesToFloat(byte4);
    }

    public static boolean toBoolean(byte[] byte4, boolean isBigEndianess) {
        BytesUtil.validateBytesLen(byte4, 4);
        if (isBigEndianess) {
            return FormatTransfer.beBytesToInt(byte4) == 1;
        }
        return FormatTransfer.leBytesToInt(byte4) == 1;
    }

    public static char[] toChars(byte[] bytes) {
        return BytesUtil.toChars(bytes, 0, bytes.length);
    }

    public static char[] toChars(byte[] bytes, int offset, int length) {
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes, offset, length);
        bb.flip();
        CharBuffer cb = DEFAULT_CHERSET.decode(bb);
        return cb.array();
    }

    public static byte[] getBytes(String str) {
        if (null == str) {
            return new byte[0];
        }
        return str.getBytes(DEFAULT_CHERSET);
    }

    public static String byteToBinary(byte b) {
        int temp = b;
        String str = Integer.toBinaryString(temp |= 0x100);
        int length = str.length();
        return str.substring(length - 8, length);
    }

    public static byte[] align4BytesArrayAddZero(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        int appendSize = (4 - data.length % 4) % 4;
        if (appendSize == 0) {
            appendSize = 4;
        }
        byte[] newSizeData = new byte[data.length + appendSize];
        System.arraycopy(data, 0, newSizeData, 0, data.length);
        return newSizeData;
    }

    public static byte[] align4BytesArray(byte[] data) {
        int appendSize = (4 - data.length % 4) % 4;
        if (appendSize == 0) {
            return data;
        }
        byte[] newSizeData = new byte[data.length + appendSize];
        System.arraycopy(data, 0, newSizeData, 0, data.length);
        return newSizeData;
    }

    public static int align4BytesLength(int size) {
        int appendSize = (4 - size % 4) % 4;
        return size + appendSize;
    }

    public static String bytesToHexSimple(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            int c = b & 0xFF;
            strBuffer.append(HEX_ARRAY[c >>> 4]);
            strBuffer.append(HEX_ARRAY[c & 0xF]);
            strBuffer.append(" ");
        }
        return strBuffer.toString();
    }

    public static String rawToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            int c = b & 0xFF;
            strBuffer.append(HEX_ARRAY[c >>> 4]);
            strBuffer.append(HEX_ARRAY[c & 0xF]);
        }
        return strBuffer.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer strBuffer = new StringBuffer(bytes.length * 2);
        int iLineCount = bytes.length / 16 + 1;
        int iCurPos = 0;
        int j = 0;
        int c = 0;
        for (int i = 0; i < iLineCount; ++i) {
            StringBuffer strTemp = new StringBuffer(16);
            for (j = 0; j < 16; ++j) {
                c = j + iCurPos >= bytes.length ? 0 : bytes[j + iCurPos] & 0xFF;
                strBuffer.append(HEX_ARRAY[c >>> 4]);
                strBuffer.append(HEX_ARRAY[c & 0xF]);
                strBuffer.append(" ");
                char v = (char)(c >= 33 && c <= 126 ? c : 46);
                strTemp.append(v);
            }
            strBuffer.append(" ; ");
            strBuffer.append(strTemp);
            strBuffer.append("\n");
            iCurPos += j;
        }
        return strBuffer.toString();
    }
}

