/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.util;

import com.huawei.gauss.util.BytesUtil;
import java.math.BigDecimal;

public class DecimalUtil {
    private static final int DEC_SIGN_MINUS = 1;
    private static final int DEC_MAX_STR_LEN = 40;
    private static final int DEC_CELL_SIZE = 13;
    private static final int DEC_CELL_DIGIT = 4;

    private static int cmCountCellDigits(short u16) {
        if (u16 >= 1000) {
            return u16 >= 10000 ? 5 : 4;
        }
        return u16 >= 100 ? 3 : (u16 >= 10 ? 2 : 1);
    }

    public static class Decimal {
        private byte sign;
        private byte ncells;
        private short expn;
        private short[] cells = new short[13];

        public Decimal() {
        }

        public Decimal(byte[] b, int length, boolean isBigEndianess) throws Exception {
            this.sign = (byte)(b[0] & 1);
            this.ncells = (byte)(b[0] >> 1);
            if (this.ncells * 2 + 2 > length) {
                throw new Exception("length mismatch: ncells * 2 + 2 <= length, ncells = " + this.ncells + ", length = " + length);
            }
            this.expn = (short)(b[1] * 4);
            for (int i = 0; i < this.ncells; ++i) {
                this.cells[i] = BytesUtil.toShort(b, 2 + i * 2, isBigEndianess);
            }
        }

        public int precision() {
            short u;
            if (this.ncells == 0) {
                return 0;
            }
            int i = 0;
            int j = 0;
            int prec = 0;
            for (i = this.ncells - 1; i > 0; --i) {
                if (this.cells[i] <= 0) continue;
                j = 0;
                u = this.cells[i];
                while (u % 10 == 0) {
                    ++j;
                    u = (short)(u / 10);
                }
                prec += i * 4 - j;
                break;
            }
            if (i == 0) {
                for (u = this.cells[0]; u % 10 == 0 && u != 0; u = (short)(u / 10)) {
                }
                prec = DecimalUtil.cmCountCellDigits(u);
            } else {
                prec += DecimalUtil.cmCountCellDigits(this.cells[0]);
            }
            return prec;
        }

        public String toString() {
            if (this.ncells == 0) {
                return "0";
            }
            StringBuilder text = new StringBuilder();
            if (this.sign == 1) {
                text.append('-');
            }
            text.append(String.format("%d", this.cells[0]));
            if (this.ncells > 1) {
                text.append(".");
            }
            for (int i = 1; i < this.ncells; ++i) {
                text.append(String.format("%04d", this.cells[i]));
            }
            if (this.expn != 0) {
                text.append(String.format("E%+d", this.expn));
            }
            BigDecimal bd = new BigDecimal(text.toString());
            int sciExp = DecimalUtil.cmCountCellDigits(this.cells[0]) - 1 + this.expn;
            int prec = this.precision();
            if (sciExp < -6 && -sciExp + prec + this.sign > 40 || sciExp > 0 && sciExp + 1 + this.sign > 40) {
                return bd.toString();
            }
            return bd.stripTrailingZeros().toPlainString();
        }

        public BigDecimal toBigDecimal() {
            return new BigDecimal(this.toString());
        }
    }
}

