/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.util;

import com.huawei.gauss.exception.ExceptionUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;

public class IOUtils {
    private static String sLocalIp;
    private static final String LOCAL_DEFUALT_IP = "127.0.0.1";

    private IOUtils() {
    }

    public static void closeQuietly(Closeable input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException ioe) {
            ExceptionUtil.handleUnThrowException("Exception occur when close inputStream", ioe);
        }
    }

    public static void closeQuietly(SocketChannel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException ioe) {
            ExceptionUtil.handleUnThrowException("Exception occur when close socketChannel", ioe);
        }
    }

    public static final String getLocalIp() {
        block5: {
            if (sLocalIp != null) {
                return sLocalIp;
            }
            String localIp = null;
            try {
                Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress ip = null;
                if (allNetInterfaces == null) break block5;
                NetworkInterface netInterface = null;
                Enumeration<InetAddress> addresses = null;
                while (allNetInterfaces.hasMoreElements()) {
                    netInterface = allNetInterfaces.nextElement();
                    addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        ip = addresses.nextElement();
                        if (ip == null || !(ip instanceof Inet4Address) || (localIp = ip.getHostAddress()).equals(LOCAL_DEFUALT_IP)) continue;
                        sLocalIp = localIp;
                        break;
                    }
                    if (sLocalIp == null) continue;
                    break;
                }
            }
            catch (SocketException e) {
                sLocalIp = LOCAL_DEFUALT_IP;
            }
        }
        return sLocalIp;
    }

    public static void closeStatementQuietly(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close statement", e);
        }
    }

    public static void closeResultsetQuietly(ResultSet rSet) {
        try {
            if (rSet != null) {
                rSet.close();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close resultset", e);
        }
    }

    public static void closeConnectionQuietly(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close resultset", e);
        }
    }
}

