/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.util;

import com.huawei.gauss.channel.context.statement.FieldType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {
    public static final String G_DEFAULT_TIMESTAMP_FMT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String G_DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int[][] G_MONTH_DAYS = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    private static final int CM_BASELINE_DAY = 730120;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_MIN = 60L;
    private static final long MILLISECS_PER_SECOND = 1000L;
    private static final long MICROSECS_PER_MILLISEC = 1000L;
    private static final long MICROSECS_PER_SECOND = 1000000L;
    private static final long NANOS_PER_MICROSEC = 1000L;
    private static final long UNITS_PER_DAY = 86400000000L;
    private static final int DAYS_1Y = 365;
    private static final int DAYS_4Y = 1461;
    private static final int DAYS_100Y = 36524;
    private static final int DAYS_400Y = 146097;
    private static final int DAYS_31 = 31;
    private static final int YEAR_4 = 4;
    private static final int YEAR_100 = 100;
    private static final int YEAR_400 = 400;
    private static final int MOUTH_NUM = 12;

    private static int daysBeforYear(int year) {
        int innerYear = year;
        return --innerYear * 365 + innerYear / 4 - innerYear / 100 + innerYear / 400;
    }

    private static int isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? 1 : 0;
    }

    private static int totalDaysBeforDate(int year, int mon, int day) {
        int totalDays = TimeUtil.daysBeforYear(year) - 730120;
        int leapYear = TimeUtil.isLeapYear(year);
        for (int i = 0; i < mon; ++i) {
            totalDays += G_MONTH_DAYS[leapYear][i];
        }
        return totalDays += day;
    }

    public static long encodeDate(String str, FieldType type, Calendar cal) throws SQLException {
        String fmt = G_DEFAULT_DATE_FORMAT;
        switch (type) {
            case TIME: 
            case DATE: {
                fmt = G_DEFAULT_DATE_FORMAT;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: {
                fmt = G_DEFAULT_TIMESTAMP_FMT;
                break;
            }
            default: {
                return 0L;
            }
        }
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        long tmpDate = 0L;
        try {
            Date date = df.parse(str);
            Calendar innerCal = cal == null ? Calendar.getInstance() : cal;
            innerCal.setTimeInMillis(date.getTime());
            int year = 0;
            year = innerCal.get(1);
            int month = 0;
            month = innerCal.get(2);
            int day = 0;
            day = innerCal.get(5);
            int hour = 0;
            hour = innerCal.get(11);
            int min = 0;
            min = innerCal.get(12);
            int sec = 0;
            sec = innerCal.get(13);
            int milliSecs = 0;
            milliSecs = innerCal.get(14);
            if (type == FieldType.DATE) {
                hour = 0;
                min = 0;
                sec = 0;
                milliSecs = 0;
            } else if (type == FieldType.TIME) {
                year = 1900;
                month = 0;
                day = 1;
            }
            int totalDays = TimeUtil.totalDaysBeforDate(year, month, day);
            tmpDate = (long)totalDays * 86400L;
            tmpDate += (long)hour * 3600L;
            tmpDate += (long)min * 60L;
            tmpDate += (long)sec;
            tmpDate = tmpDate * 1000L + (long)milliSecs;
        }
        catch (ParseException e) {
            throw new SQLException(e);
        }
        return tmpDate *= 1000L;
    }

    public static Timestamp decodeDate(long date, Calendar cal) {
        int days;
        long time = date;
        long innerData = date / 86400000000L;
        if ((time -= innerData * 86400000000L) < 0L) {
            time += 86400000000L;
            --innerData;
        }
        int microsec = (int)(time % 1000000L);
        int nanos = (int)((long)microsec * 1000L);
        int hour = (int)((time /= 1000000L) / 3600L);
        int min = (int)((time -= (long)hour * 3600L) / 60L);
        int sec = (int)(time -= (long)min * 60L);
        int year = 1;
        int mon = 0;
        int day = 0;
        for (days = (int)(innerData + 730120L); days >= 146097; days -= 146097) {
            year += 400;
        }
        for (int hundredCount = 1; days >= 36524 && hundredCount < 4; days -= 36524, ++hundredCount) {
            year += 100;
        }
        while (days >= 1461) {
            year += 4;
            days -= 1461;
        }
        while (days > 365) {
            if (TimeUtil.isLeapYear(year) == 1) {
                --days;
            }
            ++year;
            days -= 365;
        }
        if (days == 0) {
            --year;
            mon = 12;
            day = 31;
        } else {
            int i;
            mon = 1;
            int leapYear = TimeUtil.isLeapYear(year);
            for (i = 0; i < 12 && days > G_MONTH_DAYS[leapYear][i]; days -= G_MONTH_DAYS[leapYear][i], ++i) {
            }
            mon += i;
            day = days;
        }
        Calendar calendar = cal != null ? cal : Calendar.getInstance();
        calendar.set(year, mon - 1, day, hour, min, sec);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanos);
        return timestamp;
    }
}

