/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc;

import com.huawei.gauss200.jdbc.core.Logger;
import com.huawei.gauss200.jdbc.jdbc4.Jdbc4Connection;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.HostSpec;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import com.huawei.shade.com.alibaba.fastjson.JSONObject;
import com.huawei.shade.com.cloud.sdk.DefaultRequest;
import com.huawei.shade.com.cloud.sdk.auth.credentials.BasicCredentials;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.auth.signer.SignerFactory;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.org.apache.http.Header;
import com.huawei.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.huawei.shade.org.apache.http.client.methods.HttpGet;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import com.huawei.shade.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import com.huawei.shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.huawei.shade.org.apache.http.conn.ssl.SSLContexts;
import com.huawei.shade.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import com.huawei.shade.org.apache.http.conn.ssl.X509HostnameVerifier;
import com.huawei.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.huawei.shade.org.apache.http.impl.client.HttpClients;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    private static final Logger logger = new Logger();
    private static boolean logLevelSet = false;
    private static Timer cancelTimer = null;
    private CloseableHttpClient client = null;
    private Properties defaultProperties;
    private static final Object[][] knownProperties;
    public static final int MAJORVERSION = 9;
    public static final int MINORVERSION = 3;
    private static String[] protocols;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            String driverLogLevel;
            if (!logLevelSet && (driverLogLevel = this.defaultProperties.getProperty("loglevel")) != null) {
                try {
                    Driver.setLogLevel(Integer.parseInt(driverLogLevel));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return this.defaultProperties;
        }
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            merged.setProperty("user", System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            logger.debug("Can't find a classloader for the Driver; not loading driver configuration");
            return merged;
        }
        logger.debug("Loading driver configuration via classloader " + cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            logger.debug("Loading driver configuration from: " + url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties"), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            props.setProperty(propName, info.getProperty(propName));
        }
        if ((props = this.parseURL(url, props)) == null) {
            logger.debug("Error in url: " + url);
            return null;
        }
        try {
            logger.debug("Connecting with URL: " + url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            logger.debug("Connection error:", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to."), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            logger.debug("Unexpected connection error:", ex2);
            throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        return new Jdbc4Connection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties copy = new Properties(info);
        Properties parse = this.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < knownProperties.length; ++i) {
            String name = (String)knownProperties[i][0];
            props[i] = new DriverPropertyInfo(name, copy.getProperty(name));
            props[i].required = (Boolean)knownProperties[i][1];
            props[i].description = (String)knownProperties[i][2];
            if (knownProperties[i].length <= 3) continue;
            props[i].choices = (String[])knownProperties[i][3];
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 9;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    public static String getVersion() {
        return "PostgreSQL 9.3 JDBC4.1 (build 1103)";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps;
        block44: {
            urlProps = new Properties(defaults);
            String l_urlServer = url;
            String l_urlArgs = "";
            int l_qPos = url.indexOf(63);
            if (l_qPos != -1) {
                l_urlServer = url.substring(0, l_qPos);
                l_urlArgs = url.substring(l_qPos + 1);
            }
            if (!l_urlServer.startsWith("jdbc:gaussdb:") && !l_urlServer.startsWith("jdbc:dws:iam:")) {
                return null;
            }
            if (l_urlServer.startsWith("jdbc:gaussdb:")) {
                if ((l_urlServer = l_urlServer.substring("jdbc:gaussdb:".length())).startsWith("//")) {
                    int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
                    if (slash == -1) {
                        return null;
                    }
                    urlProps.setProperty("PGDBNAME", l_urlServer.substring(slash + 1));
                    String[] addresses = l_urlServer.substring(0, slash).split(",");
                    StringBuffer hosts = new StringBuffer();
                    StringBuffer ports = new StringBuffer();
                    for (int addr = 0; addr < addresses.length; ++addr) {
                        String address = addresses[addr];
                        int portIdx = address.lastIndexOf(58);
                        if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                            String portStr = address.substring(portIdx + 1);
                            try {
                                Integer.parseInt(portStr);
                            }
                            catch (NumberFormatException ex) {
                                return null;
                            }
                            ports.append(portStr);
                            hosts.append(address.subSequence(0, portIdx));
                        } else {
                            ports.append("5432");
                            hosts.append(address);
                        }
                        ports.append(',');
                        hosts.append(',');
                    }
                    ports.setLength(ports.length() - 1);
                    hosts.setLength(hosts.length() - 1);
                    urlProps.setProperty("PGPORT", ports.toString());
                    urlProps.setProperty("PGHOST", hosts.toString());
                } else {
                    urlProps.setProperty("PGPORT", "5432");
                    urlProps.setProperty("PGHOST", "localhost");
                    urlProps.setProperty("PGDBNAME", l_urlServer);
                }
                String[] args = l_urlArgs.split("&");
                for (int i = 0; i < args.length; ++i) {
                    String token = args[i];
                    if (token.length() == 0) continue;
                    int l_pos = token.indexOf(61);
                    if (l_pos == -1) {
                        urlProps.setProperty(token, "");
                        continue;
                    }
                    urlProps.setProperty(token.substring(0, l_pos), token.substring(l_pos + 1));
                }
                return urlProps;
            }
            StringBuffer tmp = new StringBuffer();
            l_urlServer = l_urlServer.substring("jdbc:dws:iam:".length());
            String ClusterIdentifier = "";
            String region = "";
            String DbUser = "";
            String AutoCreate = "";
            String AccessKeyID = "";
            String SecretAccessKey = "";
            if (l_urlServer.startsWith("//")) {
                int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
                if (slash == -1) {
                    return null;
                }
                urlProps.setProperty("PGDBNAME", l_urlServer.substring(slash + 1));
                String serverurl = l_urlServer.substring(0, slash);
                String[] clusterurl = serverurl.split(":");
                if (clusterurl.length != 2) {
                    return null;
                }
                ClusterIdentifier = clusterurl[0];
                region = clusterurl[1];
            }
            String[] args = l_urlArgs.split("&");
            for (int i = 0; i < args.length; ++i) {
                String token = args[i];
                if (token.length() == 0) continue;
                int l_pos = token.indexOf(61);
                if (l_pos == -1) {
                    urlProps.setProperty(token, "");
                    continue;
                }
                if (token.substring(0, l_pos).equals("AccessKeyID")) {
                    AccessKeyID = token.substring(l_pos + 1);
                    continue;
                }
                if (token.substring(0, l_pos).equals("SecretAccessKey")) {
                    SecretAccessKey = token.substring(l_pos + 1);
                    continue;
                }
                if (token.substring(0, l_pos).equals("DbUser")) {
                    DbUser = token.substring(l_pos + 1);
                    continue;
                }
                if (token.substring(0, l_pos).equals("AutoCreate")) {
                    AutoCreate = token.substring(l_pos + 1);
                    continue;
                }
                tmp.append("&" + token.substring(0, l_pos) + "=" + token.substring(l_pos + 1));
            }
            StringBuffer jdbcUrl = new StringBuffer();
            if (region.equals("") || ClusterIdentifier.equals("") || DbUser.equals("") || AccessKeyID.equals("") || SecretAccessKey.equals("")) {
                throw new PSQLException(GT.tr("Please confirm that all the parameters needed is added to the url."), PSQLState.CONNECTION_REJECTED);
            }
            InputStream in = null;
            Properties props = new Properties();
            String domainName = "";
            try {
                String filePath = System.getProperty("user.dir") + "/config/jdbcconfig.properties";
                in = new BufferedInputStream(new FileInputStream(filePath));
                props = new Properties();
                props.load(in);
                domainName = props.getProperty(region);
                in.close();
            }
            catch (Exception e) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        logger.debug(ioe.getMessage());
                    }
                }
                try {
                    props = new Properties();
                    in = this.getClass().getResourceAsStream("/org/postgresql/jdbcconfig.properties");
                    props.load(in);
                    domainName = props.getProperty(region);
                    in.close();
                }
                catch (Exception e1) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            logger.debug(ioe.getMessage());
                        }
                    }
                    throw new PSQLException(GT.tr("Parse jdbcconfig.properties failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e1);
                }
            }
            if (domainName == null || domainName.equals("")) {
                throw new PSQLException(GT.tr("Unrecognized region name."), PSQLState.CONNECTION_REJECTED);
            }
            jdbcUrl.append("https://" + domainName + "/credentials?");
            jdbcUrl.append("clusterName=" + ClusterIdentifier);
            jdbcUrl.append("&dbUser=" + DbUser);
            if (!AutoCreate.equals("")) {
                jdbcUrl.append("&autoCreate=" + AutoCreate);
            }
            jdbcUrl.append(tmp.toString());
            String jsonstr = "";
            jsonstr = this.getReturn(AccessKeyID, SecretAccessKey, jdbcUrl.toString(), region);
            try {
                JSONObject jsonObj = JSONObject.parseObject(jsonstr);
                if (jsonObj.get("cluster_credentials") != null) {
                    jsonstr = jsonObj.get("cluster_credentials").toString();
                    if ((jsonObj = JSONObject.parseObject(jsonstr)).get("db_user") != null) {
                        urlProps.setProperty("user", jsonObj.get("db_user").toString());
                    }
                    if (jsonObj.get("db_endpoint") != null) {
                        urlProps.setProperty("PGHOST", jsonObj.get("db_endpoint").toString());
                    }
                    if (jsonObj.get("db_port") != null) {
                        urlProps.setProperty("PGPORT", jsonObj.get("db_port").toString());
                    }
                    if (jsonObj.get("db_password") != null) {
                        urlProps.setProperty("password", jsonObj.get("db_password").toString());
                    }
                    break block44;
                }
                if (jsonObj.get("externalMessage") != null) {
                    throw new PSQLException(GT.tr(jsonObj.get("externalMessage").toString()), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                throw new PSQLException(GT.tr("The format of Token is not as expected."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("Parse the token failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
            }
        }
        if (urlProps.getProperty("ssl") == null && urlProps.getProperty("sslmode") == null) {
            urlProps.setProperty("sslmode", "require");
        }
        return urlProps;
    }

    private String getReturn(String ak, String sk, String requestUrl, String region) throws PSQLException {
        try {
            URL url = new URL(requestUrl);
            HttpMethodName httpMethod = HttpMethodName.GET;
            DefaultRequest request = new DefaultRequest("dws");
            request.setEndpoint(url.toURI());
            String urlString = url.toString();
            String parameters = null;
            if (urlString.contains("?")) {
                parameters = urlString.substring(urlString.indexOf("?") + 1);
                HashMap<String, String> parametersmap = new HashMap<String, String>();
                if (null != parameters && !"".equals(parameters)) {
                    String[] parameterarray;
                    for (String p : parameterarray = parameters.split("&")) {
                        String key = p.split("=")[0];
                        String value = p.split("=")[1];
                        parametersmap.put(key, value);
                    }
                    request.setParameters(parametersmap);
                }
            }
            request.setHttpMethod(httpMethod);
            Signer signer = SignerFactory.getSigner("dws", region);
            signer.sign(request, new BasicCredentials(ak, sk));
            HttpRequestBase httpRequestBase = this.createRequest(url, null);
            Map<String, String> requestHeaders = request.getHeaders();
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("Content-Length".toString())) continue;
                httpRequestBase.addHeader(entry.getKey(), entry.getValue());
            }
            httpRequestBase.addHeader("X-Language", "en-us");
            httpRequestBase.addHeader("Content-Type", "application/json");
            httpRequestBase.addHeader("Accept", "application/json");
            CloseableHttpResponse response = null;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).useTLS().build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
            this.client = HttpClients.custom().setSSLSocketFactory(sslSocketFactory).build();
            response = this.client.execute(httpRequestBase);
            String string = this.convertStreamToString(response.getEntity().getContent());
            return string;
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Get the token failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
        }
        finally {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public HttpRequestBase createRequest(URL url, Header header) {
        HttpGet httpRequest = new HttpGet(url.toString());
        httpRequest.addHeader(header);
        return httpRequest;
    }

    private String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioEX) {
            throw ioEX;
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = props.getProperty("PGHOST").split(",");
        String[] ports = props.getProperty("PGPORT").split(",");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = props.getProperty("loginTimeout");
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                logger.debug("Couldn't parse loginTimeout value: " + timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(int logLevel) {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            logger.setLogLevel(logLevel);
            logLevelSet = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLogLevel() {
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger.getLogLevel();
        }
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw Driver.notImplemented(this.getClass(), "getParentLogger()");
    }

    public static void purgeTimerTasks() {
        if (cancelTimer != null) {
            cancelTimer.purge();
        }
    }

    public static synchronized void addTimerTask(TimerTask timerTask, long milliSeconds) {
        if (cancelTimer == null) {
            cancelTimer = new Timer(true);
        }
        cancelTimer.schedule(timerTask, milliSeconds);
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        knownProperties = new Object[][]{{"PGDBNAME", Boolean.TRUE, "Database name to connect to; may be specified directly in the JDBC URL."}, {"user", Boolean.TRUE, "Username to connect to the database as.", null}, {"PGHOST", Boolean.FALSE, "Hostname of the PostgreSQL server; may be specified directly in the JDBC URL."}, {"PGPORT", Boolean.FALSE, "Port number to connect to the PostgreSQL server on; may be specified directly in the JDBC URL."}, {"password", Boolean.FALSE, "Password to use when authenticating."}, {"protocolVersion", Boolean.FALSE, "Force use of a particular protocol version when connecting; if set, disables protocol version fallback."}, {"ssl", Boolean.FALSE, "Control use of SSL; any nonnull value causes SSL to be required."}, {"sslfactory", Boolean.FALSE, "Provide a SSLSocketFactory class when using SSL."}, {"sslfactoryarg", Boolean.FALSE, "Argument forwarded to constructor of SSLSocketFactory class."}, {"loglevel", Boolean.FALSE, "Control the driver's log verbosity: 0 is OFF, 1 is INFO, 2 is DEBUG.", new String[]{"0", "1", "2"}}, {"allowEncodingChanges", Boolean.FALSE, "Allow the user to change the client_encoding variable."}, {"logUnclosedConnections", Boolean.FALSE, "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source."}, {"prepareThreshold", Boolean.FALSE, "Default statement prepare threshold (numeric)."}, {"binaryTransfer", Boolean.FALSE, "Use binary format for sending and receiving data if possible."}, {"binaryTransferEnable", Boolean.FALSE, "Comma separated list of types to enable binary transfer. Either OID numbers or names."}, {"binaryTransferDisable", Boolean.FALSE, "Comma separated list of types to disable binary transfer. Either OID numbers or names. Overrides values in the driver default set and values set with binaryTransferEnable."}, {"charSet", Boolean.FALSE, "When connecting to a pre-7.3 server, the database encoding to assume is in use."}, {"compatible", Boolean.FALSE, "Force compatibility of some features with an older version of the driver.", new String[]{"7.1", "7.2", "7.3", "7.4", "8.0", "8.1", "8.2"}}, {"loginTimeout", Boolean.FALSE, "The login timeout, in seconds; 0 means no timeout beyond the normal TCP connection timout."}, {"socketTimeout", Boolean.FALSE, "The timeout value for socket read operations, in seconds; 0 means no timeout."}, {"tcpKeepAlive", Boolean.FALSE, "Enable or disable TCP keep-alive probe."}, {"stringtype", Boolean.FALSE, "The type to bind String parameters as (usually 'varchar'; 'unspecified' allows implicit casting to other types)", new String[]{"varchar", "unspecified"}}, {"kerberosServerName", Boolean.FALSE, "The Kerberos service name to use when authenticating with GSSAPI.  This is equivalent to libpq's PGKRBSRVNAME environment variable."}, {"jaasApplicationName", Boolean.FALSE, "Specifies the name of the JAAS system or application login configuration."}, {"disableColumnSanitiser", Boolean.FALSE, "Enable optimization that disables column name sanitiser."}, {"currentSchema", Boolean.FALSE, "Specify the schema to set in the search_path to resolve unqualified object names."}};
        protocols = new String[]{"jdbc", "postgresql"};
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = System.currentTimeMillis() + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - System.currentTimeMillis();
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect."));
                    }
                }
                return this.result;
            }
        }
    }
}

