/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core;

import com.huawei.gauss200.jdbc.core.Logger;
import com.huawei.gauss200.jdbc.core.ProtocolConnection;
import com.huawei.gauss200.jdbc.core.v3.ConnectionFactoryImpl;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.HostSpec;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    private static final Object[][] versions = new Object[][]{{"3", new ConnectionFactoryImpl()}, {"2", new com.huawei.gauss200.jdbc.core.v2.ConnectionFactoryImpl()}};

    public static ProtocolConnection openConnection(HostSpec[] hostSpecs, String user, String database, Properties info, Logger logger) throws SQLException {
        String protoName = info.getProperty("protocolVersion");
        for (int i = 0; i < versions.length; ++i) {
            ConnectionFactory factory;
            ProtocolConnection connection;
            String versionProtoName = (String)versions[i][0];
            if (protoName != null && !protoName.equals(versionProtoName) || (connection = (factory = (ConnectionFactory)versions[i][1]).openConnectionImpl(hostSpecs, user, database, info, logger)) == null) continue;
            return connection;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract ProtocolConnection openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4, Logger var5) throws SQLException;
}

