/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core;

import com.huawei.gauss200.jdbc.core.v3.ConnectionFactoryImpl;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class Utils {
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(Integer.toHexString(data[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(data[i] & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        Charset gbkCharset = Charset.forName("GBK");
        ByteBuffer buf = null;
        buf = "GBK".equals(ConnectionFactoryImpl.CLIENT_ENCODING.toUpperCase()) ? gbkCharset.encode(CharBuffer.wrap(str)) : utf8Charset.encode(CharBuffer.wrap(str));
        byte[] b = new byte[buf.limit()];
        buf.get(b, 0, buf.limit());
        return b;
    }

    public static StringBuffer appendEscapedLiteral(StringBuffer sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(value.length() * 11 / 10);
        }
        if (standardConformingStrings) {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\'') {
                    sbuf.append('\'');
                }
                sbuf.append(ch);
            }
        } else {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\\' || ch == '\'') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
        }
        return sbuf;
    }

    public static StringBuffer appendEscapedIdentifier(StringBuffer sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(2 + value.length() * 11 / 10);
        }
        sbuf.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\u0000') {
                throw new PSQLException(GT.tr("Zero bytes may not occur in identifiers."), PSQLState.INVALID_PARAMETER_VALUE);
            }
            if (ch == '\"') {
                sbuf.append(ch);
            }
            sbuf.append(ch);
        }
        sbuf.append('\"');
        return sbuf;
    }
}

