/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core.types;

import com.huawei.gauss200.jdbc.core.types.PGBigDecimal;
import com.huawei.gauss200.jdbc.core.types.PGBoolean;
import com.huawei.gauss200.jdbc.core.types.PGDouble;
import com.huawei.gauss200.jdbc.core.types.PGFloat;
import com.huawei.gauss200.jdbc.core.types.PGShort;
import com.huawei.gauss200.jdbc.core.types.PGString;
import com.huawei.gauss200.jdbc.core.types.PGType;
import com.huawei.gauss200.jdbc.core.types.PGUnknown;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.math.BigDecimal;

public class PGInteger
implements PGType {
    private Integer val;

    protected PGInteger(Integer x) {
        this.val = x;
    }

    public static PGType castToServerType(Integer val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -7: {
                    return new PGBoolean(val == 0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case 7: {
                    return new PGFloat(new Float(val.floatValue()));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(val.doubleValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(val.toString());
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(val.shortValue()));
                }
                case 4: {
                    return new PGInteger(val);
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(val.toString()));
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return this.val.toString();
    }
}

