/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.gss;

import com.huawei.gauss200.jdbc.core.Logger;
import com.huawei.gauss200.jdbc.core.PGStream;
import com.huawei.gauss200.jdbc.gss.GSSCallbackHandler;
import com.huawei.gauss200.jdbc.gss.GssAction;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class MakeGSS {
    public static void authenticate(PGStream pgStream, String host, String user, String password, String jaasApplicationName, String kerberosServerName, Logger logger, boolean useSpnego) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" <=BE AuthenticationReqGSS");
        }
        Object result = null;
        if (jaasApplicationName == null) {
            jaasApplicationName = "pgjdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
            lc.login();
            Subject sub = lc.getSubject();
            GssAction action = new GssAction(pgStream, host, user, password, kerberosServerName, logger, useSpnego);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("GSS Authentication failed"), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        if (result != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed"), PSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

