/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.jdbc3g;

import com.huawei.gauss200.jdbc.core.BaseStatement;
import com.huawei.gauss200.jdbc.core.Field;
import com.huawei.gauss200.jdbc.core.Query;
import com.huawei.gauss200.jdbc.core.ResultCursor;
import com.huawei.gauss200.jdbc.jdbc3.AbstractJdbc3ResultSet;
import com.huawei.gauss200.jdbc.util.ByteConverter;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;

public abstract class AbstractJdbc3gResultSet
extends AbstractJdbc3ResultSet {
    public AbstractJdbc3gResultSet(Query originalQuery, BaseStatement statement, Field[] fields, List tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(originalQuery, statement, fields, tuples, cursor, maxRows, maxFieldSize, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    protected Object getUUID(String data) throws SQLException {
        UUID uuid;
        try {
            uuid = UUID.fromString(data);
        }
        catch (IllegalArgumentException iae) {
            throw new PSQLException(GT.tr("Invalid UUID data."), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)iae);
        }
        return uuid;
    }

    @Override
    protected Object getUUID(byte[] data) throws SQLException {
        return new UUID(ByteConverter.int8(data, 0), ByteConverter.int8(data, 8));
    }
}

