/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.util;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class MD5Digest {
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    private MD5Digest() {
    }

    public static byte[] encode(byte[] user, byte[] password, byte[] salt) {
        byte[] hex_digest = new byte[35];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password);
            md.update(user);
            byte[] temp_digest = md.digest();
            MD5Digest.bytesToHex(temp_digest, hex_digest, 0, 16);
            md.update(hex_digest, 0, 32);
            md.update(salt);
            byte[] pass_digest = md.digest();
            MD5Digest.bytesToHex(pass_digest, hex_digest, 3, 16);
            hex_digest[0] = 109;
            hex_digest[1] = 100;
            hex_digest[2] = 53;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hex_digest;
    }

    private static void bytesToHex(byte[] bytes, byte[] hex, int offset, int length) {
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int pos = offset;
        for (int i = 0; i < length; ++i) {
            int c = bytes[i] & 0xFF;
            int j = c >> 4;
            hex[pos++] = (byte)lookup[j];
            j = c & 0xF;
            hex[pos++] = (byte)lookup[j];
        }
    }

    public static byte[] SHA256_MD5encode(byte[] user, byte[] password, byte[] salt) {
        byte[] hex_digest = new byte[70];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password);
            md.update(user);
            byte[] temp_digest = md.digest();
            MD5Digest.bytesToHex(temp_digest, hex_digest, 0, 16);
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(hex_digest, 0, 32);
            sha.update(salt);
            byte[] pass_digest = sha.digest();
            MD5Digest.bytesToHex(pass_digest, hex_digest, 6, 32);
            hex_digest[0] = 115;
            hex_digest[1] = 104;
            hex_digest[2] = 97;
            hex_digest[3] = 50;
            hex_digest[4] = 53;
            hex_digest[5] = 54;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hex_digest;
    }

    private static byte[] sha256(byte[] str) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (md == null) {
            return null;
        }
        md.update(str);
        return md.digest();
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(MD5Digest.charToByte(hexChars[pos]) << 4 | MD5Digest.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte[] GenerateKFromPBKDF2(String password, String random64code, int server_iteration) {
        int iterations = server_iteration;
        char[] chars = password.toCharArray();
        byte[] random32code = MD5Digest.hexStringToBytes(random64code);
        PBEKeySpec spec = new PBEKeySpec(chars, random32code, iterations, 256);
        SecretKeyFactory skf = null;
        try {
            skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (skf == null) {
            return null;
        }
        byte[] hash = null;
        try {
            hash = skf.generateSecret(spec).getEncoded();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return hash;
    }

    private static byte[] GenerateKFromPBKDF2(String password, String random64code) {
        return MD5Digest.GenerateKFromPBKDF2(password, random64code, 2048);
    }

    private static byte[] GetKeyFromHmac(byte[] key, byte[] data) {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA256_ALGORITHM);
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (mac == null) {
            return null;
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return mac.doFinal(data);
    }

    private static byte[] XOR_between_password(byte[] password1, byte[] password2, int length) {
        byte[] temp = new byte[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = (byte)(password1[i] ^ password2[i]);
        }
        return temp;
    }

    public static byte[] MD5_SHA256encode(String password, String random64code, byte[] salt) {
        byte[] hex_digest = new byte[35];
        try {
            StringBuilder stringBuilder = new StringBuilder("");
            byte[] K = MD5Digest.GenerateKFromPBKDF2(password, random64code);
            byte[] server_key = MD5Digest.GetKeyFromHmac(K, "Sever Key".getBytes("UTF-8"));
            byte[] client_key = MD5Digest.GetKeyFromHmac(K, "Client Key".getBytes("UTF-8"));
            byte[] stored_key = MD5Digest.sha256(client_key);
            stringBuilder.append(random64code);
            stringBuilder.append(MD5Digest.bytesToHexString(server_key));
            stringBuilder.append(MD5Digest.bytesToHexString(stored_key));
            String EncryptString = stringBuilder.toString();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(EncryptString.getBytes("UTF-8"));
            md.update(salt);
            byte[] pass_digest = md.digest();
            MD5Digest.bytesToHex(pass_digest, hex_digest, 3, 16);
            hex_digest[0] = 109;
            hex_digest[1] = 100;
            hex_digest[2] = 53;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hex_digest;
    }

    public static byte[] RFC5802Algorithm(String password, String random64code, String token) {
        int server_iteration_350 = 2048;
        return MD5Digest.RFC5802Algorithm(password, random64code, token, null, server_iteration_350);
    }

    public static byte[] RFC5802Algorithm(String password, String random64code, String token, String server_signature, int server_iteration) {
        byte[] h = null;
        byte[] result = null;
        try {
            byte[] K = MD5Digest.GenerateKFromPBKDF2(password, random64code, server_iteration);
            byte[] server_key = MD5Digest.GetKeyFromHmac(K, "Sever Key".getBytes("UTF-8"));
            byte[] client_key = MD5Digest.GetKeyFromHmac(K, "Client Key".getBytes("UTF-8"));
            byte[] stored_key = MD5Digest.sha256(client_key);
            byte[] tokenbyte = MD5Digest.hexStringToBytes(token);
            byte[] client_signature = MD5Digest.GetKeyFromHmac(server_key, tokenbyte);
            if (server_signature != null && !server_signature.equals(MD5Digest.bytesToHexString(client_signature))) {
                return null;
            }
            byte[] hmac_result = MD5Digest.GetKeyFromHmac(stored_key, tokenbyte);
            h = MD5Digest.XOR_between_password(hmac_result, client_key, client_key.length);
            result = new byte[h.length * 2];
            MD5Digest.bytesToHex(h, result, 0, h.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] RFC5802Algorithm(String password, String random64code, String token, int server_iteration) {
        return MD5Digest.RFC5802Algorithm(password, random64code, token, null, server_iteration);
    }
}

