/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.alibaba.fastjson.parser.deserializer;

import com.huawei.shade.com.alibaba.fastjson.JSONException;
import com.huawei.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.huawei.shade.com.alibaba.fastjson.parser.JSONLexer;
import com.huawei.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeserializer
implements ObjectDeserializer {
    private final Class<?> enumClass;
    protected final Enum[] enums;
    protected final Enum[] ordinalEnums;
    protected long[] enumNameHashCodes;

    public EnumDeserializer(Class<?> enumClass) {
        int i;
        this.enumClass = enumClass;
        this.ordinalEnums = (Enum[])enumClass.getEnumConstants();
        long[] enumNameHashCodes = new long[this.ordinalEnums.length];
        this.enumNameHashCodes = new long[this.ordinalEnums.length];
        for (i = 0; i < this.ordinalEnums.length; ++i) {
            String name = this.ordinalEnums[i].name();
            long hash = -3750763034362895579L;
            for (int j = 0; j < name.length(); ++j) {
                char ch = name.charAt(j);
                hash ^= (long)ch;
                hash *= 1099511628211L;
            }
            enumNameHashCodes[i] = hash;
            this.enumNameHashCodes[i] = hash;
        }
        Arrays.sort(this.enumNameHashCodes);
        this.enums = new Enum[this.ordinalEnums.length];
        block2: for (i = 0; i < this.enumNameHashCodes.length; ++i) {
            for (int j = 0; j < enumNameHashCodes.length; ++j) {
                if (this.enumNameHashCodes[i] != enumNameHashCodes[j]) continue;
                this.enums[i] = this.ordinalEnums[j];
                continue block2;
            }
        }
    }

    public Enum getEnumByHashCode(long hashCode) {
        if (this.enums == null) {
            return null;
        }
        int enumIndex = Arrays.binarySearch(this.enumNameHashCodes, hashCode);
        if (enumIndex < 0) {
            return null;
        }
        return this.enums[enumIndex];
    }

    public Enum<?> valueOf(int ordinal) {
        return this.ordinalEnums[ordinal];
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        try {
            JSONLexer lexer = parser.lexer;
            int token = lexer.token();
            if (token == 2) {
                int intValue = lexer.intValue();
                lexer.nextToken(16);
                if (intValue < 0 || intValue > this.ordinalEnums.length) {
                    throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + intValue);
                }
                return (T)this.ordinalEnums[intValue];
            }
            if (token == 4) {
                String strVal = lexer.stringVal();
                lexer.nextToken(16);
                if (strVal.length() == 0) {
                    return null;
                }
                return (T)Enum.valueOf(this.enumClass, strVal);
            }
            if (token == 8) {
                Object value = null;
                lexer.nextToken(16);
                return null;
            }
            Object value = parser.parse();
            throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + value);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

