/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.alibaba.fastjson.serializer;

import com.huawei.shade.com.alibaba.fastjson.JSON;
import com.huawei.shade.com.alibaba.fastjson.JSONObject;
import com.huawei.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.huawei.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import sun.reflect.annotation.AnnotationType;

public class AnnotationSerializer
implements ObjectSerializer {
    public static AnnotationSerializer instance = new AnnotationSerializer();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        Class<?> objClass = object.getClass();
        Class<?>[] interfaces = objClass.getInterfaces();
        if (interfaces.length == 1 && interfaces[0].isAnnotation()) {
            Class<?> annotationClass = interfaces[0];
            AnnotationType type = AnnotationType.getInstance(annotationClass);
            Map<String, Method> members = type.members();
            JSONObject json = new JSONObject(members.size());
            Iterator<Map.Entry<String, Method>> iterator = members.entrySet().iterator();
            Object val = null;
            while (iterator.hasNext()) {
                Map.Entry<String, Method> entry = iterator.next();
                try {
                    val = entry.getValue().invoke(object, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                json.put(entry.getKey(), JSON.toJSON(val));
            }
            serializer.write(json);
            return;
        }
    }
}

