/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.auth.credentials;

import com.huawei.shade.com.cloud.sdk.ClientException;
import com.huawei.shade.com.cloud.sdk.auth.credentials.BasicCredentials;
import com.huawei.shade.com.cloud.sdk.auth.credentials.Credentials;
import com.huawei.shade.com.cloud.sdk.auth.credentials.CredentialsProvider;
import com.huawei.shade.com.cloud.sdk.util.StringUtils;

public class EnvironmentVariableCredentialsProvider
implements CredentialsProvider {
    @Override
    public Credentials getCredentials() {
        String secretKey;
        String accessKey = System.getenv("ACCESS_KEY_ID");
        if (accessKey == null) {
            accessKey = System.getenv("ACCESS_KEY");
        }
        if ((secretKey = System.getenv("SECRET_KEY")) == null) {
            secretKey = System.getenv("SECRET_ACCESS_KEY");
        }
        accessKey = StringUtils.trim(accessKey);
        secretKey = StringUtils.trim(secretKey);
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new ClientException("Unable to load credentials from environment variables (ACCESS_KEY_ID (or ACCESS_KEY) and SECRET_KEY (or SECRET_ACCESS_KEY))");
        }
        return new BasicCredentials(accessKey, secretKey);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

