/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.auth.signer.internal;

import com.huawei.shade.com.cloud.sdk.Request;
import com.huawei.shade.com.cloud.sdk.auth.signer.internal.SignerUtils;

public final class SignerRequestParams {
    private final Request<?> request;
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;

    public SignerRequestParams(Request<?> request, String regionNameOverride, String serviceNameOverride, String signingAlgorithm) {
        this(request, regionNameOverride, serviceNameOverride, signingAlgorithm, null);
    }

    public SignerRequestParams(Request<?> request, String regionNameOverride, String serviceNameOverride, String signingAlgorithm, String signDate) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.signingDateTimeMilli = null == signDate ? this.getSigningDate(request) : this.getSigningDate(signDate);
        this.request = request;
        this.formattedSigningDate = SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceName = serviceNameOverride != null ? serviceNameOverride : "";
        this.regionName = regionNameOverride != null ? regionNameOverride : "";
        this.scope = this.generateScope(this.formattedSigningDate, this.serviceName, this.regionName);
        this.formattedSigningDateTime = SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = signingAlgorithm;
    }

    private final long getSigningDate(Request<?> request) {
        return System.currentTimeMillis() - (long)(request.getTimeOffset() * 1000);
    }

    private final long getSigningDate(String signDate) {
        return SignerUtils.parseMillis(signDate);
    }

    private String generateScope(String dateStamp, String serviceName, String regionName) {
        StringBuilder scopeBuilder = new StringBuilder();
        return scopeBuilder.append(dateStamp).append("/").append(regionName).append("/").append(serviceName).append("/").append("sdk_request").toString();
    }

    public Request<?> getRequest() {
        return this.request;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

