/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.core.io;

import com.huawei.shade.com.fasterxml.jackson.core.JsonEncoding;
import com.huawei.shade.com.fasterxml.jackson.core.util.BufferRecycler;
import com.huawei.shade.com.fasterxml.jackson.core.util.TextBuffer;

public final class IOContext {
    protected final Object _sourceRef;
    protected JsonEncoding _encoding;
    protected final boolean _managedResource;
    protected final BufferRecycler _bufferRecycler;
    protected byte[] _readIOBuffer = null;
    protected byte[] _writeEncodingBuffer = null;
    protected byte[] _base64Buffer = null;
    protected char[] _tokenCBuffer = null;
    protected char[] _concatCBuffer = null;
    protected char[] _nameCopyBuffer = null;

    public IOContext(BufferRecycler bufferRecycler, Object object, boolean bl) {
        this._bufferRecycler = bufferRecycler;
        this._sourceRef = object;
        this._managedResource = bl;
    }

    public void setEncoding(JsonEncoding jsonEncoding) {
        this._encoding = jsonEncoding;
    }

    public Object getSourceReference() {
        return this._sourceRef;
    }

    public JsonEncoding getEncoding() {
        return this._encoding;
    }

    public boolean isResourceManaged() {
        return this._managedResource;
    }

    public TextBuffer constructTextBuffer() {
        return new TextBuffer(this._bufferRecycler);
    }

    public byte[] allocReadIOBuffer() {
        this._verifyAlloc(this._readIOBuffer);
        this._readIOBuffer = this._bufferRecycler.allocByteBuffer(BufferRecycler.ByteBufferType.READ_IO_BUFFER);
        return this._readIOBuffer;
    }

    public byte[] allocWriteEncodingBuffer() {
        this._verifyAlloc(this._writeEncodingBuffer);
        this._writeEncodingBuffer = this._bufferRecycler.allocByteBuffer(BufferRecycler.ByteBufferType.WRITE_ENCODING_BUFFER);
        return this._writeEncodingBuffer;
    }

    public byte[] allocBase64Buffer() {
        this._verifyAlloc(this._base64Buffer);
        this._base64Buffer = this._bufferRecycler.allocByteBuffer(BufferRecycler.ByteBufferType.BASE64_CODEC_BUFFER);
        return this._base64Buffer;
    }

    public char[] allocTokenBuffer() {
        this._verifyAlloc(this._tokenCBuffer);
        this._tokenCBuffer = this._bufferRecycler.allocCharBuffer(BufferRecycler.CharBufferType.TOKEN_BUFFER);
        return this._tokenCBuffer;
    }

    public char[] allocConcatBuffer() {
        this._verifyAlloc(this._concatCBuffer);
        this._concatCBuffer = this._bufferRecycler.allocCharBuffer(BufferRecycler.CharBufferType.CONCAT_BUFFER);
        return this._concatCBuffer;
    }

    public char[] allocNameCopyBuffer(int n) {
        this._verifyAlloc(this._nameCopyBuffer);
        this._nameCopyBuffer = this._bufferRecycler.allocCharBuffer(BufferRecycler.CharBufferType.NAME_COPY_BUFFER, n);
        return this._nameCopyBuffer;
    }

    public void releaseReadIOBuffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._readIOBuffer);
            this._readIOBuffer = null;
            this._bufferRecycler.releaseByteBuffer(BufferRecycler.ByteBufferType.READ_IO_BUFFER, byArray);
        }
    }

    public void releaseWriteEncodingBuffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._writeEncodingBuffer);
            this._writeEncodingBuffer = null;
            this._bufferRecycler.releaseByteBuffer(BufferRecycler.ByteBufferType.WRITE_ENCODING_BUFFER, byArray);
        }
    }

    public void releaseBase64Buffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._base64Buffer);
            this._base64Buffer = null;
            this._bufferRecycler.releaseByteBuffer(BufferRecycler.ByteBufferType.BASE64_CODEC_BUFFER, byArray);
        }
    }

    public void releaseTokenBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._tokenCBuffer);
            this._tokenCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(BufferRecycler.CharBufferType.TOKEN_BUFFER, cArray);
        }
    }

    public void releaseConcatBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._concatCBuffer);
            this._concatCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(BufferRecycler.CharBufferType.CONCAT_BUFFER, cArray);
        }
    }

    public void releaseNameCopyBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._nameCopyBuffer);
            this._nameCopyBuffer = null;
            this._bufferRecycler.releaseCharBuffer(BufferRecycler.CharBufferType.NAME_COPY_BUFFER, cArray);
        }
    }

    private final void _verifyAlloc(Object object) {
        if (object != null) {
            throw new IllegalStateException("Trying to call same allocXxx() method second time");
        }
    }

    private final void _verifyRelease(Object object, Object object2) {
        if (object != object2) {
            throw new IllegalArgumentException("Trying to release buffer not owned by the context");
        }
    }
}

