/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind;

import com.huawei.shade.com.fasterxml.jackson.core.JsonLocation;
import com.huawei.shade.com.fasterxml.jackson.core.JsonParser;
import com.huawei.shade.com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JsonMappingException
extends JsonProcessingException {
    private static final long serialVersionUID = 1L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<Reference> _path;

    public JsonMappingException(String string) {
        super(string);
    }

    public JsonMappingException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public JsonMappingException(String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
    }

    public JsonMappingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
    }

    public static JsonMappingException from(JsonParser jsonParser, String string) {
        return new JsonMappingException(string, jsonParser == null ? null : jsonParser.getTokenLocation());
    }

    public static JsonMappingException from(JsonParser jsonParser, String string, Throwable throwable) {
        return new JsonMappingException(string, jsonParser == null ? null : jsonParser.getTokenLocation(), throwable);
    }

    public static JsonMappingException fromUnexpectedIOE(IOException iOException) {
        return new JsonMappingException("Unexpected IOException (of type " + iOException.getClass().getName() + "): " + iOException.getMessage(), null, iOException);
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, String string) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, string));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, int n) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, n));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Reference reference) {
        JsonMappingException jsonMappingException;
        if (throwable instanceof JsonMappingException) {
            jsonMappingException = (JsonMappingException)throwable;
        } else {
            String string = throwable.getMessage();
            if (string == null || string.length() == 0) {
                string = "(was " + throwable.getClass().getName() + ")";
            }
            jsonMappingException = new JsonMappingException(string, null, throwable);
        }
        jsonMappingException.prependPath(reference);
        return jsonMappingException;
    }

    public List<Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder stringBuilder) {
        this._appendPathDesc(stringBuilder);
        return stringBuilder;
    }

    public void prependPath(Object object, String string) {
        Reference reference = new Reference(object, string);
        this.prependPath(reference);
    }

    public void prependPath(Object object, int n) {
        Reference reference = new Reference(object, n);
        this.prependPath(reference);
    }

    public void prependPath(Reference reference) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(reference);
        }
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        String string = super.getMessage();
        if (this._path == null) {
            return string;
        }
        StringBuilder stringBuilder = string == null ? new StringBuilder() : new StringBuilder(string);
        stringBuilder.append(" (through reference chain: ");
        stringBuilder = this.getPathReference(stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected void _appendPathDesc(StringBuilder stringBuilder) {
        if (this._path == null) {
            return;
        }
        Iterator iterator = this._path.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((Reference)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("->");
        }
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Object _from;
        protected String _fieldName;
        protected int _index = -1;

        protected Reference() {
        }

        public Reference(Object object) {
            this._from = object;
        }

        public Reference(Object object, String string) {
            this._from = object;
            if (string == null) {
                throw new NullPointerException("Can not pass null fieldName");
            }
            this._fieldName = string;
        }

        public Reference(Object object, int n) {
            this._from = object;
            this._index = n;
        }

        public void setFrom(Object object) {
            this._from = object;
        }

        public void setFieldName(String string) {
            this._fieldName = string;
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public Object getFrom() {
            return this._from;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public int getIndex() {
            return this._index;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Class<?> clazz = this._from instanceof Class ? (Class<?>)this._from : this._from.getClass();
            Package package_ = clazz.getPackage();
            if (package_ != null) {
                stringBuilder.append(package_.getName());
                stringBuilder.append('.');
            }
            stringBuilder.append(clazz.getSimpleName());
            stringBuilder.append('[');
            if (this._fieldName != null) {
                stringBuilder.append('\"');
                stringBuilder.append(this._fieldName);
                stringBuilder.append('\"');
            } else if (this._index >= 0) {
                stringBuilder.append(this._index);
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

