/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind;

import com.huawei.shade.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.huawei.shade.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public abstract class PropertyNamingStrategy
implements Serializable {
    public static final PropertyNamingStrategy CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES = new LowerCaseWithUnderscoresStrategy();
    public static final PropertyNamingStrategy PASCAL_CASE_TO_CAMEL_CASE = new PascalCaseStrategy();

    public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
        return string;
    }

    public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
        return string;
    }

    public static class PascalCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            if (string == null || string.length() == 0) {
                return string;
            }
            char c = string.charAt(0);
            if (Character.isUpperCase(c)) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(0, Character.toUpperCase(c));
            return stringBuilder.toString();
        }
    }

    public static class LowerCaseWithUnderscoresStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n * 2);
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (i <= 0 && c == '_') continue;
                if (Character.isUpperCase(c)) {
                    if (!bl && n2 > 0 && stringBuilder.charAt(n2 - 1) != '_') {
                        stringBuilder.append('_');
                        ++n2;
                    }
                    c = Character.toLowerCase(c);
                    bl = true;
                } else {
                    bl = false;
                }
                stringBuilder.append(c);
                ++n2;
            }
            return n2 > 0 ? stringBuilder.toString() : string;
        }
    }

    public static abstract class PropertyNamingStrategyBase
    extends PropertyNamingStrategy {
        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
            return this.translate(string);
        }

        public abstract String translate(String var1);
    }
}

