/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.fasterxml.jackson.databind.deser.std;

import com.huawei.shade.com.fasterxml.jackson.core.JsonParser;
import com.huawei.shade.com.fasterxml.jackson.core.JsonProcessingException;
import com.huawei.shade.com.fasterxml.jackson.databind.BeanProperty;
import com.huawei.shade.com.fasterxml.jackson.databind.DeserializationContext;
import com.huawei.shade.com.fasterxml.jackson.databind.JavaType;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonDeserializer;
import com.huawei.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.huawei.shade.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.huawei.shade.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.huawei.shade.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.huawei.shade.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.huawei.shade.com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;

public class StdDelegatingDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Converter<Object, T> _converter;
    protected final JavaType _delegateType;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public StdDelegatingDeserializer(Converter<?, T> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateDeserializer = null;
    }

    public StdDelegatingDeserializer(Converter<Object, T> converter, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        super(javaType);
        this._converter = converter;
        this._delegateType = javaType;
        this._delegateDeserializer = jsonDeserializer;
    }

    protected StdDelegatingDeserializer<T> withDelegate(Converter<Object, T> converter, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        if (this.getClass() != StdDelegatingDeserializer.class) {
            throw new IllegalStateException("Sub-class " + this.getClass().getName() + " must override 'withDelegate'");
        }
        return new StdDelegatingDeserializer<T>(converter, javaType, jsonDeserializer);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        if (this._delegateDeserializer != null && this._delegateDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)this._delegateDeserializer)).resolve(deserializationContext);
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (this._delegateDeserializer != null) {
            JsonDeserializer<?> jsonDeserializer;
            if (this._delegateDeserializer instanceof ContextualDeserializer && (jsonDeserializer = ((ContextualDeserializer)((Object)this._delegateDeserializer)).createContextual(deserializationContext, beanProperty)) != this._delegateDeserializer) {
                return this.withDelegate(this._converter, this._delegateType, jsonDeserializer);
            }
            return this;
        }
        JavaType javaType = this._converter.getInputType(deserializationContext.getTypeFactory());
        return this.withDelegate(this._converter, javaType, deserializationContext.findContextualValueDeserializer(javaType, beanProperty));
    }

    @Override
    public JsonDeserializer<?> getDelegatee() {
        return this._delegateDeserializer;
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object = this._delegateDeserializer.deserialize(jsonParser, deserializationContext);
        if (object == null) {
            return null;
        }
        return this.convertValue(object);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        Object object = this._delegateDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
        if (object == null) {
            return null;
        }
        return this.convertValue(object);
    }

    protected T convertValue(Object object) {
        return this._converter.convert(object);
    }
}

